/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import java.util.List;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.expression.IdentifierTreeImpl;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeTree;

public class MemberSelectExpressionTreeImpl
extends AbstractTypedTree
implements MemberSelectExpressionTree {
    private ExpressionTree expression;
    private final int dims;
    private final IdentifierTree identifier;

    public MemberSelectExpressionTreeImpl(int dims, IdentifierTreeImpl identifier, List<AstNode> children) {
        super(Tree.Kind.MEMBER_SELECT);
        this.dims = dims;
        this.identifier = identifier;
        for (AstNode child : children) {
            this.addChild(child);
        }
    }

    public MemberSelectExpressionTreeImpl(ExpressionTree expression, IdentifierTree identifier, AstNode ... children) {
        super(Tree.Kind.MEMBER_SELECT);
        this.dims = -1;
        this.expression = (ExpressionTree)Preconditions.checkNotNull((Object)expression);
        this.identifier = (IdentifierTree)Preconditions.checkNotNull((Object)identifier);
        for (AstNode child : children) {
            this.addChild(child);
        }
    }

    public MemberSelectExpressionTreeImpl(AstNode astNode, ExpressionTree expression, IdentifierTree identifier) {
        super(astNode);
        this.dims = -1;
        this.expression = (ExpressionTree)Preconditions.checkNotNull((Object)expression);
        this.identifier = (IdentifierTree)Preconditions.checkNotNull((Object)identifier);
    }

    public MemberSelectExpressionTreeImpl completeWithExpression(ExpressionTree expression) {
        Preconditions.checkState((this.dims >= 0 && this.expression == null ? 1 : 0) != 0);
        ExpressionTree result = expression;
        for (int i = 0; i < this.dims; ++i) {
            result = new JavaTree.ArrayTypeTreeImpl(null, (TypeTree)((Object)result));
        }
        this.expression = result;
        return this;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.MEMBER_SELECT;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken operatorToken() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IdentifierTree identifier() {
        return this.identifier;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitMemberSelectExpression(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.expression, this.identifier});
    }
}

