/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeTree;

public class NewClassTreeImpl
extends AbstractTypedTree
implements NewClassTree {
    private ExpressionTree enclosingExpression = null;
    private TypeTree identifier;
    private final List<ExpressionTree> arguments;
    @Nullable
    private final ClassTree classBody;

    public NewClassTreeImpl(List arguments, @Nullable ClassTreeImpl classBody, AstNode ... children) {
        super(Tree.Kind.NEW_CLASS);
        this.arguments = (List)Preconditions.checkNotNull((Object)arguments);
        this.classBody = classBody;
        for (AstNode child : children) {
            this.addChild(child);
        }
    }

    public NewClassTreeImpl completeWithIdentifier(TypeTree identifier) {
        this.identifier = identifier;
        return this;
    }

    public NewClassTreeImpl completeWithEnclosingExpression(ExpressionTree enclosingExpression) {
        this.enclosingExpression = enclosingExpression;
        return this;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.NEW_CLASS;
    }

    @Override
    @Nullable
    public ExpressionTree enclosingExpression() {
        return this.enclosingExpression;
    }

    @Override
    public List<Tree> typeArguments() {
        return ImmutableList.of();
    }

    @Override
    public TypeTree identifier() {
        return this.identifier;
    }

    @Override
    public List<ExpressionTree> arguments() {
        return this.arguments;
    }

    @Override
    @Nullable
    public ClassTree classBody() {
        return this.classBody;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitNewClass(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator)Iterators.forArray((Object[])new Tree[]{this.enclosingExpression, this.identifier}), this.arguments.iterator(), (Iterator)Iterators.singletonIterator((Object)this.classBody));
    }

    public IdentifierTree getConstructorIdentifier() {
        return this.getConstructorIdentifier(this.identifier());
    }

    private IdentifierTree getConstructorIdentifier(Tree constructorSelect) {
        IdentifierTree constructorIdentifier;
        if (constructorSelect.is(Tree.Kind.MEMBER_SELECT)) {
            MemberSelectExpressionTree mset = (MemberSelectExpressionTree)constructorSelect;
            constructorIdentifier = mset.identifier();
        } else if (constructorSelect.is(Tree.Kind.IDENTIFIER)) {
            constructorIdentifier = (IdentifierTree)constructorSelect;
        } else if (constructorSelect.is(Tree.Kind.PARAMETERIZED_TYPE)) {
            constructorIdentifier = this.getConstructorIdentifier(((ParameterizedTypeTree)constructorSelect).type());
        } else {
            throw new IllegalStateException("Constructor select is not of the expected type " + constructorSelect);
        }
        return constructorIdentifier;
    }
}

