/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

public class ForEachStatementImpl
extends JavaTree
implements ForEachStatement {
    private final VariableTree variable;
    private final ExpressionTree expression;
    private final StatementTree statement;

    public ForEachStatementImpl(VariableTree variable, ExpressionTree expression, StatementTree statement, AstNode ... children) {
        super(Tree.Kind.FOR_EACH_STATEMENT);
        this.variable = (VariableTree)Preconditions.checkNotNull((Object)variable);
        this.expression = (ExpressionTree)Preconditions.checkNotNull((Object)expression);
        this.statement = (StatementTree)Preconditions.checkNotNull((Object)statement);
        for (AstNode child : children) {
            this.addChild(child);
        }
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.FOR_EACH_STATEMENT;
    }

    @Override
    public SyntaxToken forKeyword() {
        return InternalSyntaxToken.createLegacy(this.getAstNode().getFirstChild(new AstNodeType[]{JavaKeyword.FOR}));
    }

    @Override
    public SyntaxToken openParenToken() {
        return InternalSyntaxToken.createLegacy(this.getAstNode().getFirstChild(new AstNodeType[]{JavaPunctuator.LPAR}));
    }

    @Override
    public VariableTree variable() {
        return this.variable;
    }

    @Override
    public SyntaxToken colonToken() {
        return InternalSyntaxToken.createLegacy(this.getAstNode().getFirstChild(new AstNodeType[]{JavaPunctuator.COLON}));
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken closeParenToken() {
        return InternalSyntaxToken.createLegacy(this.getAstNode().getFirstChild(new AstNodeType[]{JavaPunctuator.RPAR}));
    }

    @Override
    public StatementTree statement() {
        return this.statement;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitForEachStatement(this);
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.variable, this.expression, this.statement});
    }
}

