/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import java.util.Collection;
import java.util.List;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.checks.CheckFactory;
import org.sonar.api.checks.NoSonarFilter;
import org.sonar.api.config.Settings;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.java.JavaSquid;
import org.sonar.java.ast.api.JavaMetric;
import org.sonar.plugins.java.bridges.Bridge;
import org.sonar.plugins.java.bridges.BridgeFactory;
import org.sonar.plugins.java.bridges.ResourceIndex;
import org.sonar.squidbridge.api.Query;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.squidbridge.api.SourcePackage;
import org.sonar.squidbridge.api.SourceProject;
import org.sonar.squidbridge.indexer.QueryByMeasure;
import org.sonar.squidbridge.indexer.QueryByType;
import org.sonar.squidbridge.measures.MetricDef;

public class Bridges {
    private final JavaSquid squid;
    private final Settings settings;

    public Bridges(JavaSquid squid, Settings settings) {
        this.squid = squid;
        this.settings = settings;
    }

    public void save(SensorContext context, Project project, CheckFactory checkFactory, NoSonarFilter noSonarFilter, RulesProfile profile) {
        boolean skipPackageDesignAnalysis = this.settings.getBoolean("sonar.skipPackageDesign");
        ResourceIndex resourceIndex = new ResourceIndex(skipPackageDesignAnalysis).loadSquidResources(this.squid, context, project);
        List<Bridge> bridges = BridgeFactory.create(this.squid.isBytecodeScanned(), skipPackageDesignAnalysis, context, checkFactory, resourceIndex, this.squid, noSonarFilter, profile);
        this.saveProject(resourceIndex, bridges);
        this.savePackages(resourceIndex, bridges);
        this.saveFiles(resourceIndex, bridges);
    }

    private void saveProject(ResourceIndex resourceIndex, List<Bridge> bridges) {
        SourceProject squidProject = (SourceProject)this.squid.search(new QueryByType(SourceProject.class)).iterator().next();
        Resource sonarResource = (Resource)resourceIndex.get(squidProject);
        for (Bridge bridge : bridges) {
            bridge.onProject(squidProject, (Project)sonarResource);
        }
    }

    private void savePackages(ResourceIndex resourceIndex, List<Bridge> bridges) {
        Collection packages = this.squid.search(new QueryByType(SourcePackage.class));
        for (SourceCode squidPackage : packages) {
            Resource sonarPackage = (Resource)resourceIndex.get(squidPackage);
            if (sonarPackage == null) continue;
            for (Bridge bridge : bridges) {
                bridge.onPackage((SourcePackage)squidPackage, sonarPackage);
            }
        }
    }

    private void saveFiles(ResourceIndex resourceIndex, List<Bridge> bridges) {
        Collection squidFiles = this.squid.search(new Query[]{new QueryByType(SourceFile.class), new QueryByMeasure((MetricDef)JavaMetric.TESTS, QueryByMeasure.Operator.LESS_THAN, 1.0)});
        for (SourceCode squidFile : squidFiles) {
            Resource sonarFile = (Resource)resourceIndex.get(squidFile);
            if (sonarFile == null) continue;
            for (Bridge bridge : bridges) {
                bridge.onFile((SourceFile)squidFile, sonarFile);
            }
        }
    }
}

