/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java.bridges;

import java.util.HashSet;
import java.util.Set;
import org.sonar.api.checks.NoSonarFilter;
import org.sonar.api.resources.Resource;
import org.sonar.plugins.java.bridges.Bridge;
import org.sonar.squidbridge.api.SourceClass;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.squidbridge.api.SourceMethod;

public class NoSonarFilterLoader
extends Bridge {
    private NoSonarFilter noSonarFilter;

    protected NoSonarFilterLoader(NoSonarFilter noSonarFilter) {
        this.noSonarFilter = noSonarFilter;
    }

    @Override
    public void onFile(SourceFile squidFile, Resource sonarFile) {
        HashSet<Integer> ignoredLines = new HashSet<Integer>(squidFile.getNoSonarTagLines());
        NoSonarFilterLoader.visitSuppressWarnings((SourceCode)squidFile, ignoredLines);
        this.noSonarFilter.addResource(sonarFile, ignoredLines);
    }

    private static void visitSuppressWarnings(SourceCode sourceCode, Set<Integer> ignoredLines) {
        if (sourceCode instanceof SourceClass && ((SourceClass)sourceCode).isSuppressWarnings() || sourceCode instanceof SourceMethod && ((SourceMethod)sourceCode).isSuppressWarnings()) {
            NoSonarFilterLoader.visitLines(sourceCode, ignoredLines);
        }
        if (sourceCode.hasChildren()) {
            for (SourceCode child : sourceCode.getChildren()) {
                NoSonarFilterLoader.visitSuppressWarnings(child, ignoredLines);
            }
        }
    }

    private static void visitLines(SourceCode sourceCode, Set<Integer> ignoredLines) {
        for (int line = sourceCode.getStartAtLine(); line <= sourceCode.getEndAtLine(); ++line) {
            ignoredLines.add(line);
        }
    }
}

