/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import java.util.Collection;
import java.util.List;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.checks.CheckFactory;
import org.sonar.api.checks.NoSonarFilter;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.java.JavaSquid;
import org.sonar.java.ast.api.JavaMetric;
import org.sonar.plugins.java.bridges.Bridge;
import org.sonar.plugins.java.bridges.BridgeFactory;
import org.sonar.plugins.java.bridges.ResourceIndex;
import org.sonar.squid.api.Query;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourcePackage;
import org.sonar.squid.api.SourceProject;
import org.sonar.squid.indexer.QueryByMeasure;
import org.sonar.squid.indexer.QueryByType;
import org.sonar.squid.measures.MetricDef;

public class Bridges {
    private final JavaSquid squid;

    public Bridges(JavaSquid squid) {
        this.squid = squid;
    }

    public void save(SensorContext context, Project project, CheckFactory checkFactory, NoSonarFilter noSonarFilter, RulesProfile profile) {
        boolean skipPackageDesignAnalysis = project.getConfiguration().getBoolean("sonar.skipPackageDesign", false);
        ResourceIndex resourceIndex = new ResourceIndex(skipPackageDesignAnalysis).loadSquidResources(this.squid, context, project);
        List<Bridge> bridges = BridgeFactory.create(this.squid.isBytecodeScanned(), skipPackageDesignAnalysis, context, checkFactory, resourceIndex, this.squid, noSonarFilter, profile);
        this.saveProject(resourceIndex, bridges);
        this.savePackages(resourceIndex, bridges);
        this.saveFiles(resourceIndex, bridges);
    }

    private void saveProject(ResourceIndex resourceIndex, List<Bridge> bridges) {
        SourceProject squidProject = (SourceProject)this.squid.search(new QueryByType(SourceProject.class)).iterator().next();
        Resource sonarResource = (Resource)resourceIndex.get(squidProject);
        for (Bridge bridge : bridges) {
            bridge.onProject(squidProject, (Project)sonarResource);
        }
    }

    private void savePackages(ResourceIndex resourceIndex, List<Bridge> bridges) {
        Collection packages = this.squid.search(new QueryByType(SourcePackage.class));
        for (SourceCode squidPackage : packages) {
            Resource sonarPackage = (Resource)resourceIndex.get(squidPackage);
            if (sonarPackage == null) continue;
            for (Bridge bridge : bridges) {
                bridge.onPackage((SourcePackage)squidPackage, sonarPackage);
            }
        }
    }

    private void saveFiles(ResourceIndex resourceIndex, List<Bridge> bridges) {
        Collection squidFiles = this.squid.search(new Query[]{new QueryByType(SourceFile.class), new QueryByMeasure((MetricDef)JavaMetric.TESTS, QueryByMeasure.Operator.LESS_THAN, 1.0)});
        for (SourceCode squidFile : squidFiles) {
            Resource sonarFile = (Resource)resourceIndex.get(squidFile);
            if (sonarFile == null) continue;
            for (Bridge bridge : bridges) {
                bridge.onFile((SourceFile)squidFile, sonarFile);
            }
        }
    }
}

