/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java.bridges;

import java.util.Locale;
import java.util.Set;
import org.sonar.api.resources.Resource;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.Violation;
import org.sonar.plugins.java.bridges.Bridge;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.SourceFile;

public class ChecksBridge
extends Bridge {
    @Override
    public void onFile(SourceFile squidFile, Resource sonarFile) {
        Set messages = squidFile.getCheckMessages();
        if (messages != null) {
            for (CheckMessage checkMessage : messages) {
                ActiveRule rule;
                Object check = checkMessage.getCheck();
                if (check instanceof RuleKey) {
                    RuleKey ruleKey = (RuleKey)check;
                    rule = this.profile.getActiveRule(ruleKey.repository(), ruleKey.rule());
                } else {
                    rule = this.checkFactory.getActiveRule(checkMessage.getCheck());
                }
                if (rule == null) continue;
                Violation violation = Violation.create((ActiveRule)rule, (Resource)sonarFile);
                violation.setLineId(checkMessage.getLine());
                violation.setMessage(checkMessage.getText(Locale.ENGLISH));
                violation.setCost(checkMessage.getCost());
                this.context.saveViolation(violation, checkMessage.isBypassExclusion());
            }
            messages.clear();
        }
    }
}

