/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.colorizer;

import org.sonar.channel.CodeReader;
import org.sonar.channel.EndMatcher;
import org.sonar.colorizer.HtmlCodeBuilder;
import org.sonar.colorizer.Tokenizer;

public class JavaAnnotationTokenizer
extends Tokenizer {
    private final String tagBefore;
    private final String tagAfter;
    private static final EndMatcher endTokenMatcher = new EndMatcher(){

        public boolean match(int endFlag) {
            return !Character.isJavaIdentifierPart(endFlag);
        }
    };

    public JavaAnnotationTokenizer(String tagBefore, String tagAfter) {
        this.tagBefore = tagBefore;
        this.tagAfter = tagAfter;
    }

    public boolean consume(CodeReader code, HtmlCodeBuilder codeBuilder) {
        if (code.peek() == 64) {
            codeBuilder.appendWithoutTransforming(this.tagBefore);
            code.popTo(endTokenMatcher, (Appendable)codeBuilder);
            codeBuilder.appendWithoutTransforming(this.tagAfter);
            return true;
        }
        return false;
    }
}

