/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.parser;

import com.sonar.sslr.api.GenericTokenType;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.grammar.LexerlessGrammarBuilder;
import org.sonar.sslr.parser.LexerlessGrammar;

public enum JavaGrammar implements GrammarRuleKey
{
    COMPILATION_UNIT,
    PACKAGE_DECLARATION,
    IMPORT_DECLARATION,
    TYPE_DECLARATION,
    ANNOTATION,
    QUALIFIED_IDENTIFIER,
    QUALIFIED_IDENTIFIER_LIST,
    MODIFIER,
    CLASS_DECLARATION,
    ENUM_DECLARATION,
    INTERFACE_DECLARATION,
    ANNOTATION_TYPE_DECLARATION,
    TYPE_PARAMETERS,
    CLASS_TYPE,
    CLASS_TYPE_LIST,
    CLASS_BODY,
    CLASS_BODY_DECLARATION,
    CLASS_INIT_DECLARATION,
    BLOCK,
    MEMBER_DECL,
    FIELD_DECLARATION,
    GENERIC_METHOD_OR_CONSTRUCTOR_REST,
    TYPE,
    METHOD_DECLARATOR_REST,
    VARIABLE_DECLARATORS,
    VOID_METHOD_DECLARATOR_REST,
    CONSTRUCTOR_DECLARATOR_REST,
    FORMAL_PARAMETERS,
    DIM,
    METHOD_BODY,
    INTERFACE_BODY,
    INTERFACE_BODY_DECLARATION,
    INTERFACE_MEMBER_DECL,
    INTERFACE_METHOD_OR_FIELD_DECL,
    INTERFACE_GENERIC_METHOD_DECL,
    VOID_INTERFACE_METHOD_DECLARATORS_REST,
    INTERFACE_METHOD_OR_FIELD_REST,
    CONSTANT_DECLARATORS_REST,
    INTERFACE_METHOD_DECLARATOR_REST,
    CONSTANT_DECLARATOR_REST,
    CONSTANT_DECLARATOR,
    VARIABLE_INITIALIZER,
    ENUM_BODY,
    ENUM_CONSTANTS,
    ENUM_BODY_DECLARATIONS,
    ENUM_CONSTANT,
    ARGUMENTS,
    LOCAL_VARIABLE_DECLARATION_STATEMENT,
    VARIABLE_MODIFIERS,
    VARIABLE_DECLARATOR,
    FORMAL_PARAMETER,
    FORMAL_PARAMETER_DECLS,
    FORMAL_PARAMETERS_DECLS_REST,
    VARIABLE_DECLARATOR_ID,
    BLOCK_STATEMENTS,
    BLOCK_STATEMENT,
    STATEMENT,
    LABELED_STATEMENT,
    EXPRESSION_STATEMENT,
    IF_STATEMENT,
    WHILE_STATEMENT,
    FOR_STATEMENT,
    ASSERT_STATEMENT,
    SWITCH_STATEMENT,
    DO_STATEMENT,
    BREAK_STATEMENT,
    CONTINUE_STATEMENT,
    RETURN_STATEMENT,
    SYNCHRONIZED_STATEMENT,
    THROW_STATEMENT,
    EMPTY_STATEMENT,
    EXPRESSION,
    RESOURCE,
    PAR_EXPRESSION,
    FOR_INIT,
    FOR_UPDATE,
    CATCH_CLAUSE,
    CATCH_FORMAL_PARAMETER,
    CATCH_TYPE,
    FINALLY_,
    SWITCH_BLOCK_STATEMENT_GROUPS,
    STATEMENT_EXPRESSION,
    TRY_STATEMENT,
    TRY_WITH_RESOURCES_STATEMENT,
    RESOURCE_SPECIFICATION,
    SWITCH_BLOCK_STATEMENT_GROUP,
    SWITCH_LABEL,
    CONSTANT_EXPRESSION,
    BASIC_TYPE,
    TYPE_ARGUMENTS,
    TYPE_ARGUMENT,
    TYPE_PARAMETER,
    BOUND,
    CONDITIONAL_EXPRESSION,
    DEFAULT_VALUE,
    ANNOTATION_TYPE_BODY,
    ANNOTATION_TYPE_ELEMENT_DECLARATION,
    ANNOTATION_TYPE_ELEMENT_REST,
    ANNOTATION_METHOD_OR_CONSTANT_REST,
    ANNOTATION_METHOD_REST,
    ANNOTATION_REST,
    NORMAL_ANNOTATION_REST,
    ELEMENT_VALUE_PAIRS,
    ELEMENT_VALUE_PAIR,
    ELEMENT_VALUE,
    ELEMENT_VALUE_ARRAY_INITIALIZER,
    ELEMENT_VALUES,
    SINGLE_ELEMENT_ANNOTATION_REST,
    ASSIGNMENT_EXPRESSION,
    ASSIGNMENT_OPERATOR,
    CONDITIONAL_OR_EXPRESSION,
    CONDITIONAL_AND_EXPRESSION,
    INCLUSIVE_OR_EXPRESSION,
    EXCLUSIVE_OR_EXPRESSION,
    AND_EXPRESSION,
    EQUALITY_EXPRESSION,
    RELATIONAL_EXPRESSION,
    SHIFT_EXPRESSION,
    ADDITIVE_EXPRESSION,
    MULTIPLICATIVE_EXPRESSION,
    UNARY_EXPRESSION,
    PREFIX_OP,
    PRIMARY,
    SELECTOR,
    POST_FIX_OP,
    NON_WILDCARD_TYPE_ARGUMENTS,
    EXPLICIT_GENERIC_INVOCATION_SUFFIX,
    SUPER_SUFFIX,
    LITERAL,
    CREATOR,
    IDENTIFIER_SUFFIX,
    EXPLICIT_GENERIC_INVOCATION,
    INNER_CREATOR,
    DIM_EXPR,
    CREATED_NAME,
    CLASS_CREATOR_REST,
    DIAMOND,
    ARRAY_CREATOR_REST,
    ARRAY_INITIALIZER,
    EOF,
    LETTER_OR_DIGIT,
    KEYWORD,
    SPACING,
    METHOD_REFERENCE,
    LAMBDA_EXPRESSION,
    LAMBDA_PARAMETERS,
    LAMBDA_BODY,
    ARROW,
    UNARY_EXPRESSION_NOT_PLUS_MINUS,
    CAST_EXPRESSION;

    private static final String EXP_REGEXP = "(?:[Ee][+-]?+[0-9_]++)";
    private static final String BINARY_EXP_REGEXP = "(?:[Pp][+-]?+[0-9_]++)";
    private static final String FLOATING_LITERAL_WITHOUT_SUFFIX_REGEXP = "(?:[0-9][0-9_]*+\\.([0-9_]++)?+(?:[Ee][+-]?+[0-9_]++)?+|\\.[0-9][0-9_]*+(?:[Ee][+-]?+[0-9_]++)?+|[0-9][0-9_]*+(?:[Ee][+-]?+[0-9_]++)|0[xX][0-9_a-fA-F]++\\.[0-9_a-fA-F]*+(?:[Pp][+-]?+[0-9_]++)|0[xX][0-9_a-fA-F]++(?:[Pp][+-]?+[0-9_]++))";
    private static final String INTEGER_LITERAL_REGEXP = "(?:0[xX][0-9_a-fA-F]++|0[bB][01_]++|[0-9][0-9_]*+)";
    private final String internalName;

    public static LexerlessGrammar createGrammar() {
        return JavaGrammar.createGrammarBuilder().build();
    }

    public static LexerlessGrammarBuilder createGrammarBuilder() {
        LexerlessGrammarBuilder b = LexerlessGrammarBuilder.create();
        JavaGrammar.punctuators(b);
        JavaGrammar.keywords(b);
        JavaGrammar.compilationsUnits(b);
        JavaGrammar.classDeclaration(b);
        JavaGrammar.interfaceDeclarations(b);
        JavaGrammar.enums(b);
        JavaGrammar.formalParameters(b);
        JavaGrammar.blocksAndStatements(b);
        JavaGrammar.expressions(b);
        JavaGrammar.types(b);
        JavaGrammar.annotations(b);
        JavaGrammar.literals(b);
        b.setRootRule(COMPILATION_UNIT);
        return b;
    }

    private static void punctuators(LexerlessGrammarBuilder b) {
        JavaGrammar.punctuator(b, JavaPunctuator.AT, "@");
        JavaGrammar.punctuator(b, JavaPunctuator.AND, "&", b.nextNot(b.firstOf("=", "&")));
        JavaGrammar.punctuator(b, JavaPunctuator.ANDAND, "&&");
        JavaGrammar.punctuator(b, JavaPunctuator.ANDEQU, "&=");
        JavaGrammar.punctuator(b, JavaPunctuator.BANG, "!", b.nextNot("="));
        JavaGrammar.punctuator(b, JavaPunctuator.BSR, ">>>", b.nextNot("="));
        JavaGrammar.punctuator(b, JavaPunctuator.BSREQU, ">>>=");
        JavaGrammar.punctuator(b, JavaPunctuator.COLON, ":");
        JavaGrammar.punctuator(b, JavaPunctuator.DBLECOLON, "::");
        JavaGrammar.punctuator(b, JavaPunctuator.COMMA, ",");
        JavaGrammar.punctuator(b, JavaPunctuator.DEC, "--");
        JavaGrammar.punctuator(b, JavaPunctuator.DIV, "/", b.nextNot("="));
        JavaGrammar.punctuator(b, JavaPunctuator.DIVEQU, "/=");
        JavaGrammar.punctuator(b, JavaPunctuator.DOT, ".");
        JavaGrammar.punctuator(b, JavaPunctuator.ELLIPSIS, "...");
        JavaGrammar.punctuator(b, JavaPunctuator.EQU, "=", b.nextNot("="));
        JavaGrammar.punctuator(b, JavaPunctuator.EQUAL, "==");
        JavaGrammar.punctuator(b, JavaPunctuator.GE, ">=");
        JavaGrammar.punctuator(b, JavaPunctuator.GT, ">", b.nextNot(b.firstOf("=", ">")));
        JavaGrammar.punctuator(b, JavaPunctuator.HAT, "^", b.nextNot("="));
        JavaGrammar.punctuator(b, JavaPunctuator.HATEQU, "^=");
        JavaGrammar.punctuator(b, JavaPunctuator.INC, "++");
        JavaGrammar.punctuator(b, JavaPunctuator.LBRK, "[");
        JavaGrammar.punctuator(b, JavaPunctuator.LT, "<", b.nextNot(b.firstOf("=", "<")));
        JavaGrammar.punctuator(b, JavaPunctuator.LE, "<=");
        JavaGrammar.punctuator(b, JavaPunctuator.LPAR, "(");
        JavaGrammar.punctuator(b, JavaPunctuator.LWING, "{");
        JavaGrammar.punctuator(b, JavaPunctuator.MINUS, "-", b.nextNot(b.firstOf("-", "=")));
        JavaGrammar.punctuator(b, JavaPunctuator.MINUSEQU, "-=");
        JavaGrammar.punctuator(b, JavaPunctuator.MOD, "%", b.nextNot("="));
        JavaGrammar.punctuator(b, JavaPunctuator.MODEQU, "%=");
        JavaGrammar.punctuator(b, JavaPunctuator.NOTEQUAL, "!=");
        JavaGrammar.punctuator(b, JavaPunctuator.OR, "|", b.nextNot(b.firstOf("=", "|")));
        JavaGrammar.punctuator(b, JavaPunctuator.OREQU, "|=");
        JavaGrammar.punctuator(b, JavaPunctuator.OROR, "||");
        JavaGrammar.punctuator(b, JavaPunctuator.PLUS, "+", b.nextNot(b.firstOf("=", "+")));
        JavaGrammar.punctuator(b, JavaPunctuator.PLUSEQU, "+=");
        JavaGrammar.punctuator(b, JavaPunctuator.QUERY, "?");
        JavaGrammar.punctuator(b, JavaPunctuator.RBRK, "]");
        JavaGrammar.punctuator(b, JavaPunctuator.RPAR, ")");
        JavaGrammar.punctuator(b, JavaPunctuator.RWING, "}");
        JavaGrammar.punctuator(b, JavaPunctuator.SEMI, ";");
        JavaGrammar.punctuator(b, JavaPunctuator.SL, "<<", b.nextNot("="));
        JavaGrammar.punctuator(b, JavaPunctuator.SLEQU, "<<=");
        JavaGrammar.punctuator(b, JavaPunctuator.SR, ">>", b.nextNot(b.firstOf("=", ">")));
        JavaGrammar.punctuator(b, JavaPunctuator.SREQU, ">>=");
        JavaGrammar.punctuator(b, JavaPunctuator.STAR, "*", b.nextNot("="));
        JavaGrammar.punctuator(b, JavaPunctuator.STAREQU, "*=");
        JavaGrammar.punctuator(b, JavaPunctuator.TILDA, "~");
        JavaGrammar.punctuator(b, JavaPunctuator.LPOINT, "<");
        JavaGrammar.punctuator(b, JavaPunctuator.RPOINT, ">");
        JavaGrammar.punctuator(b, ARROW, "->");
    }

    private static void keywords(LexerlessGrammarBuilder b) {
        b.rule(LETTER_OR_DIGIT).is(JavaGrammar.javaIdentifierPart(b));
        for (JavaKeyword tokenType : JavaKeyword.values()) {
            b.rule(tokenType).is(tokenType.getValue(), b.nextNot(LETTER_OR_DIGIT), SPACING);
        }
        Object[] keywords = JavaKeyword.keywordValues();
        Arrays.sort(keywords);
        ArrayUtils.reverse(keywords);
        b.rule(KEYWORD).is(b.firstOf(keywords[0], keywords[1], ArrayUtils.subarray(keywords, 2, keywords.length)), b.nextNot(LETTER_OR_DIGIT));
    }

    private static void punctuator(LexerlessGrammarBuilder b, GrammarRuleKey ruleKey, String value) {
        b.rule(ruleKey).is(value, SPACING);
    }

    private static void punctuator(LexerlessGrammarBuilder b, GrammarRuleKey ruleKey, String value, Object element) {
        b.rule(ruleKey).is(value, element, SPACING);
    }

    private static void literals(LexerlessGrammarBuilder b) {
        b.rule(SPACING).is(b.skippedTrivia(JavaGrammar.whitespace(b)), b.zeroOrMore(b.commentTrivia(b.firstOf(JavaGrammar.inlineComment(b), JavaGrammar.multilineComment(b))), b.skippedTrivia(JavaGrammar.whitespace(b)))).skip();
        b.rule(EOF).is(b.token(GenericTokenType.EOF, b.endOfInput())).skip();
        b.rule(JavaTokenType.CHARACTER_LITERAL).is(JavaGrammar.characterLiteral(b), SPACING);
        b.rule(JavaTokenType.LITERAL).is(JavaGrammar.stringLiteral(b), SPACING);
        b.rule(JavaTokenType.FLOAT_LITERAL).is(b.regexp("(?:[0-9][0-9_]*+\\.([0-9_]++)?+(?:[Ee][+-]?+[0-9_]++)?+|\\.[0-9][0-9_]*+(?:[Ee][+-]?+[0-9_]++)?+|[0-9][0-9_]*+(?:[Ee][+-]?+[0-9_]++)|0[xX][0-9_a-fA-F]++\\.[0-9_a-fA-F]*+(?:[Pp][+-]?+[0-9_]++)|0[xX][0-9_a-fA-F]++(?:[Pp][+-]?+[0-9_]++))[fF]|[0-9][0-9_]*+[fF]"), SPACING);
        b.rule(JavaTokenType.DOUBLE_LITERAL).is(b.regexp("(?:[0-9][0-9_]*+\\.([0-9_]++)?+(?:[Ee][+-]?+[0-9_]++)?+|\\.[0-9][0-9_]*+(?:[Ee][+-]?+[0-9_]++)?+|[0-9][0-9_]*+(?:[Ee][+-]?+[0-9_]++)|0[xX][0-9_a-fA-F]++\\.[0-9_a-fA-F]*+(?:[Pp][+-]?+[0-9_]++)|0[xX][0-9_a-fA-F]++(?:[Pp][+-]?+[0-9_]++))[dD]?+|[0-9][0-9_]*+[dD]"), SPACING);
        b.rule(JavaTokenType.LONG_LITERAL).is(b.regexp("(?:0[xX][0-9_a-fA-F]++|0[bB][01_]++|[0-9][0-9_]*+)[lL]"), SPACING);
        b.rule(JavaTokenType.INTEGER_LITERAL).is(b.regexp(INTEGER_LITERAL_REGEXP), SPACING);
        b.rule(JavaTokenType.IDENTIFIER).is(b.firstOf(b.next(JavaKeyword.ENUM), b.nextNot(KEYWORD)), JavaGrammar.javaIdentifier(b), SPACING);
        b.rule(LITERAL).is(b.firstOf(JavaKeyword.TRUE, JavaKeyword.FALSE, JavaKeyword.NULL, JavaTokenType.CHARACTER_LITERAL, JavaTokenType.LITERAL, JavaTokenType.FLOAT_LITERAL, JavaTokenType.DOUBLE_LITERAL, JavaTokenType.LONG_LITERAL, JavaTokenType.INTEGER_LITERAL));
    }

    private static Object characterLiteral(LexerlessGrammarBuilder b) {
        return b.sequence(b.next("'"), b.regexp("'([^'\\\\]*+(\\\\[\\s\\S])?+)*+'"));
    }

    private static Object stringLiteral(LexerlessGrammarBuilder b) {
        return b.sequence(b.next("\""), b.regexp("\"([^\"\\\\]*+(\\\\[\\s\\S])?+)*+\""));
    }

    private static Object whitespace(LexerlessGrammarBuilder b) {
        return b.regexp("\\s*+");
    }

    private static Object inlineComment(LexerlessGrammarBuilder b) {
        return b.regexp("//[^\\n\\r]*+");
    }

    private static Object multilineComment(LexerlessGrammarBuilder b) {
        return b.regexp("/\\*[\\s\\S]*?\\*\\/");
    }

    private static Object javaIdentifier(LexerlessGrammarBuilder b) {
        return b.regexp("\\p{javaJavaIdentifierStart}++\\p{javaJavaIdentifierPart}*+");
    }

    private static Object javaIdentifierPart(LexerlessGrammarBuilder b) {
        return b.regexp("\\p{javaJavaIdentifierPart}");
    }

    private static void types(LexerlessGrammarBuilder b) {
        b.rule(TYPE).is(b.firstOf(BASIC_TYPE, CLASS_TYPE), b.zeroOrMore(b.zeroOrMore(ANNOTATION), DIM));
        b.rule(CLASS_TYPE).is(b.zeroOrMore(ANNOTATION), JavaTokenType.IDENTIFIER, b.optional(TYPE_ARGUMENTS), b.zeroOrMore(JavaPunctuator.DOT, b.zeroOrMore(ANNOTATION), JavaTokenType.IDENTIFIER, b.optional(TYPE_ARGUMENTS)));
        b.rule(CLASS_TYPE_LIST).is(CLASS_TYPE, b.zeroOrMore(JavaPunctuator.COMMA, CLASS_TYPE));
        b.rule(TYPE_ARGUMENTS).is(JavaPunctuator.LPOINT, TYPE_ARGUMENT, b.zeroOrMore(JavaPunctuator.COMMA, TYPE_ARGUMENT), JavaPunctuator.RPOINT);
        b.rule(TYPE_ARGUMENT).is(b.zeroOrMore(ANNOTATION), b.firstOf(TYPE, b.sequence(JavaPunctuator.QUERY, b.optional(b.firstOf(JavaKeyword.EXTENDS, JavaKeyword.SUPER), b.zeroOrMore(ANNOTATION), TYPE))));
        b.rule(TYPE_PARAMETERS).is(JavaPunctuator.LPOINT, TYPE_PARAMETER, b.zeroOrMore(JavaPunctuator.COMMA, TYPE_PARAMETER), JavaPunctuator.RPOINT);
        b.rule(TYPE_PARAMETER).is(b.zeroOrMore(ANNOTATION), JavaTokenType.IDENTIFIER, b.optional(JavaKeyword.EXTENDS, BOUND));
        b.rule(BOUND).is(CLASS_TYPE, b.zeroOrMore(JavaPunctuator.AND, b.zeroOrMore(ANNOTATION), CLASS_TYPE));
        b.rule(MODIFIER).is(b.firstOf(ANNOTATION, JavaKeyword.PUBLIC, JavaKeyword.PROTECTED, JavaKeyword.PRIVATE, JavaKeyword.ABSTRACT, JavaKeyword.STATIC, JavaKeyword.FINAL, JavaKeyword.TRANSIENT, JavaKeyword.VOLATILE, JavaKeyword.SYNCHRONIZED, JavaKeyword.NATIVE, JavaKeyword.DEFAULT, JavaKeyword.STRICTFP));
    }

    private static void compilationsUnits(LexerlessGrammarBuilder b) {
        b.rule(COMPILATION_UNIT).is(SPACING, b.optional(PACKAGE_DECLARATION), b.zeroOrMore(IMPORT_DECLARATION), b.zeroOrMore(TYPE_DECLARATION), EOF);
        b.rule(PACKAGE_DECLARATION).is(b.zeroOrMore(ANNOTATION), JavaKeyword.PACKAGE, QUALIFIED_IDENTIFIER, JavaPunctuator.SEMI);
        b.rule(IMPORT_DECLARATION).is(JavaKeyword.IMPORT, b.optional(JavaKeyword.STATIC), QUALIFIED_IDENTIFIER, b.optional(JavaPunctuator.DOT, JavaPunctuator.STAR), JavaPunctuator.SEMI);
        b.rule(TYPE_DECLARATION).is(b.firstOf(b.sequence(b.zeroOrMore(MODIFIER), b.firstOf(CLASS_DECLARATION, ENUM_DECLARATION, INTERFACE_DECLARATION, ANNOTATION_TYPE_DECLARATION)), JavaPunctuator.SEMI));
    }

    private static void classDeclaration(LexerlessGrammarBuilder b) {
        b.rule(CLASS_DECLARATION).is(JavaKeyword.CLASS, JavaTokenType.IDENTIFIER, b.optional(TYPE_PARAMETERS), b.optional(JavaKeyword.EXTENDS, CLASS_TYPE), b.optional(JavaKeyword.IMPLEMENTS, CLASS_TYPE_LIST), CLASS_BODY);
        b.rule(CLASS_BODY).is(JavaPunctuator.LWING, b.zeroOrMore(CLASS_BODY_DECLARATION), JavaPunctuator.RWING);
        b.rule(CLASS_BODY_DECLARATION).is(b.firstOf(JavaPunctuator.SEMI, CLASS_INIT_DECLARATION, b.sequence(b.zeroOrMore(MODIFIER), MEMBER_DECL)));
        b.rule(CLASS_INIT_DECLARATION).is(b.optional(JavaKeyword.STATIC), BLOCK);
        b.rule(MEMBER_DECL).is(b.firstOf(b.sequence(TYPE_PARAMETERS, GENERIC_METHOD_OR_CONSTRUCTOR_REST), b.sequence(TYPE, JavaTokenType.IDENTIFIER, METHOD_DECLARATOR_REST), FIELD_DECLARATION, b.sequence(JavaKeyword.VOID, JavaTokenType.IDENTIFIER, VOID_METHOD_DECLARATOR_REST), b.sequence(JavaTokenType.IDENTIFIER, CONSTRUCTOR_DECLARATOR_REST), INTERFACE_DECLARATION, CLASS_DECLARATION, ENUM_DECLARATION, ANNOTATION_TYPE_DECLARATION));
        b.rule(FIELD_DECLARATION).is(TYPE, VARIABLE_DECLARATORS, JavaPunctuator.SEMI);
        b.rule(GENERIC_METHOD_OR_CONSTRUCTOR_REST).is(b.firstOf(b.sequence(b.firstOf(TYPE, JavaKeyword.VOID), JavaTokenType.IDENTIFIER, METHOD_DECLARATOR_REST), b.sequence(JavaTokenType.IDENTIFIER, CONSTRUCTOR_DECLARATOR_REST)));
        b.rule(METHOD_DECLARATOR_REST).is(FORMAL_PARAMETERS, b.zeroOrMore(b.zeroOrMore(ANNOTATION), DIM), b.optional(JavaKeyword.THROWS, QUALIFIED_IDENTIFIER_LIST), b.firstOf(METHOD_BODY, JavaPunctuator.SEMI));
        b.rule(VOID_METHOD_DECLARATOR_REST).is(FORMAL_PARAMETERS, b.optional(JavaKeyword.THROWS, QUALIFIED_IDENTIFIER_LIST), b.firstOf(METHOD_BODY, JavaPunctuator.SEMI));
        b.rule(CONSTRUCTOR_DECLARATOR_REST).is(FORMAL_PARAMETERS, b.optional(JavaKeyword.THROWS, QUALIFIED_IDENTIFIER_LIST), METHOD_BODY);
        b.rule(METHOD_BODY).is(BLOCK);
    }

    private static void enums(LexerlessGrammarBuilder b) {
        b.rule(ENUM_DECLARATION).is(JavaKeyword.ENUM, JavaTokenType.IDENTIFIER, b.optional(JavaKeyword.IMPLEMENTS, CLASS_TYPE_LIST), ENUM_BODY);
        b.rule(ENUM_BODY).is(JavaPunctuator.LWING, b.optional(ENUM_CONSTANTS), b.optional(JavaPunctuator.COMMA), b.optional(ENUM_BODY_DECLARATIONS), JavaPunctuator.RWING);
        b.rule(ENUM_CONSTANTS).is(ENUM_CONSTANT, b.zeroOrMore(JavaPunctuator.COMMA, ENUM_CONSTANT));
        b.rule(ENUM_CONSTANT).is(b.zeroOrMore(ANNOTATION), JavaTokenType.IDENTIFIER, b.optional(ARGUMENTS), b.optional(CLASS_BODY));
        b.rule(ENUM_BODY_DECLARATIONS).is(JavaPunctuator.SEMI, b.zeroOrMore(CLASS_BODY_DECLARATION));
    }

    private static void interfaceDeclarations(LexerlessGrammarBuilder b) {
        b.rule(INTERFACE_DECLARATION).is(JavaKeyword.INTERFACE, JavaTokenType.IDENTIFIER, b.optional(TYPE_PARAMETERS), b.optional(JavaKeyword.EXTENDS, CLASS_TYPE_LIST), INTERFACE_BODY);
        b.rule(INTERFACE_BODY).is(JavaPunctuator.LWING, b.zeroOrMore(INTERFACE_BODY_DECLARATION), JavaPunctuator.RWING);
        b.rule(INTERFACE_BODY_DECLARATION).is(b.firstOf(b.sequence(b.zeroOrMore(MODIFIER), INTERFACE_MEMBER_DECL), JavaPunctuator.SEMI));
        b.rule(INTERFACE_MEMBER_DECL).is(b.firstOf(INTERFACE_METHOD_OR_FIELD_DECL, INTERFACE_GENERIC_METHOD_DECL, b.sequence(JavaKeyword.VOID, JavaTokenType.IDENTIFIER, VOID_INTERFACE_METHOD_DECLARATORS_REST), INTERFACE_DECLARATION, ANNOTATION_TYPE_DECLARATION, CLASS_DECLARATION, ENUM_DECLARATION));
        b.rule(INTERFACE_METHOD_OR_FIELD_DECL).is(TYPE, JavaTokenType.IDENTIFIER, INTERFACE_METHOD_OR_FIELD_REST);
        b.rule(INTERFACE_METHOD_OR_FIELD_REST).is(b.firstOf(b.sequence(CONSTANT_DECLARATORS_REST, JavaPunctuator.SEMI), INTERFACE_METHOD_DECLARATOR_REST));
        b.rule(INTERFACE_METHOD_DECLARATOR_REST).is(FORMAL_PARAMETERS, b.zeroOrMore(b.zeroOrMore(ANNOTATION), DIM), b.optional(JavaKeyword.THROWS, QUALIFIED_IDENTIFIER_LIST), b.firstOf(JavaPunctuator.SEMI, BLOCK));
        b.rule(INTERFACE_GENERIC_METHOD_DECL).is(TYPE_PARAMETERS, b.firstOf(TYPE, JavaKeyword.VOID), JavaTokenType.IDENTIFIER, INTERFACE_METHOD_DECLARATOR_REST);
        b.rule(VOID_INTERFACE_METHOD_DECLARATORS_REST).is(FORMAL_PARAMETERS, b.optional(JavaKeyword.THROWS, QUALIFIED_IDENTIFIER_LIST), b.firstOf(JavaPunctuator.SEMI, BLOCK));
        b.rule(CONSTANT_DECLARATORS_REST).is(CONSTANT_DECLARATOR_REST, b.zeroOrMore(JavaPunctuator.COMMA, CONSTANT_DECLARATOR));
        b.rule(CONSTANT_DECLARATOR).is(JavaTokenType.IDENTIFIER, CONSTANT_DECLARATOR_REST);
        b.rule(CONSTANT_DECLARATOR_REST).is(b.zeroOrMore(DIM), JavaPunctuator.EQU, VARIABLE_INITIALIZER);
    }

    private static void formalParameters(LexerlessGrammarBuilder b) {
        b.rule(FORMAL_PARAMETERS).is(JavaPunctuator.LPAR, b.optional(FORMAL_PARAMETER_DECLS), JavaPunctuator.RPAR);
        b.rule(FORMAL_PARAMETER).is(b.zeroOrMore(b.firstOf(JavaKeyword.FINAL, ANNOTATION)), TYPE, VARIABLE_DECLARATOR_ID);
        b.rule(FORMAL_PARAMETER_DECLS).is(b.zeroOrMore(b.firstOf(JavaKeyword.FINAL, ANNOTATION)), TYPE, FORMAL_PARAMETERS_DECLS_REST);
        b.rule(FORMAL_PARAMETERS_DECLS_REST).is(b.firstOf(b.sequence(VARIABLE_DECLARATOR_ID, b.optional(JavaPunctuator.COMMA, FORMAL_PARAMETER_DECLS)), b.sequence(b.zeroOrMore(ANNOTATION), JavaPunctuator.ELLIPSIS, VARIABLE_DECLARATOR_ID)));
        b.rule(VARIABLE_DECLARATOR_ID).is(JavaTokenType.IDENTIFIER, b.zeroOrMore(b.zeroOrMore(ANNOTATION), DIM));
    }

    private static void annotations(LexerlessGrammarBuilder b) {
        b.rule(ANNOTATION_TYPE_DECLARATION).is(JavaPunctuator.AT, JavaKeyword.INTERFACE, JavaTokenType.IDENTIFIER, ANNOTATION_TYPE_BODY);
        b.rule(ANNOTATION_TYPE_BODY).is(JavaPunctuator.LWING, b.zeroOrMore(ANNOTATION_TYPE_ELEMENT_DECLARATION), JavaPunctuator.RWING);
        b.rule(ANNOTATION_TYPE_ELEMENT_DECLARATION).is(b.firstOf(b.sequence(b.zeroOrMore(MODIFIER), ANNOTATION_TYPE_ELEMENT_REST), JavaPunctuator.SEMI));
        b.rule(ANNOTATION_TYPE_ELEMENT_REST).is(b.firstOf(b.sequence(TYPE, JavaTokenType.IDENTIFIER, ANNOTATION_METHOD_OR_CONSTANT_REST, JavaPunctuator.SEMI), CLASS_DECLARATION, ENUM_DECLARATION, INTERFACE_DECLARATION, ANNOTATION_TYPE_DECLARATION));
        b.rule(ANNOTATION_METHOD_OR_CONSTANT_REST).is(b.firstOf(ANNOTATION_METHOD_REST, CONSTANT_DECLARATORS_REST));
        b.rule(ANNOTATION_METHOD_REST).is(JavaPunctuator.LPAR, JavaPunctuator.RPAR, b.optional(DEFAULT_VALUE));
        b.rule(DEFAULT_VALUE).is(JavaKeyword.DEFAULT, ELEMENT_VALUE);
        b.rule(ANNOTATION).is(JavaPunctuator.AT, QUALIFIED_IDENTIFIER, b.optional(ANNOTATION_REST));
        b.rule(ANNOTATION_REST).is(b.firstOf(NORMAL_ANNOTATION_REST, SINGLE_ELEMENT_ANNOTATION_REST));
        b.rule(NORMAL_ANNOTATION_REST).is(JavaPunctuator.LPAR, b.optional(ELEMENT_VALUE_PAIRS), JavaPunctuator.RPAR);
        b.rule(ELEMENT_VALUE_PAIRS).is(ELEMENT_VALUE_PAIR, b.zeroOrMore(JavaPunctuator.COMMA, ELEMENT_VALUE_PAIR));
        b.rule(ELEMENT_VALUE_PAIR).is(JavaTokenType.IDENTIFIER, JavaPunctuator.EQU, ELEMENT_VALUE);
        b.rule(ELEMENT_VALUE).is(b.firstOf(CONDITIONAL_EXPRESSION, ANNOTATION, ELEMENT_VALUE_ARRAY_INITIALIZER));
        b.rule(ELEMENT_VALUE_ARRAY_INITIALIZER).is(JavaPunctuator.LWING, b.optional(ELEMENT_VALUES), b.optional(JavaPunctuator.COMMA), JavaPunctuator.RWING);
        b.rule(ELEMENT_VALUES).is(ELEMENT_VALUE, b.zeroOrMore(JavaPunctuator.COMMA, ELEMENT_VALUE));
        b.rule(SINGLE_ELEMENT_ANNOTATION_REST).is(JavaPunctuator.LPAR, ELEMENT_VALUE, JavaPunctuator.RPAR);
    }

    private static void blocksAndStatements(LexerlessGrammarBuilder b) {
        b.rule(BLOCK).is(JavaPunctuator.LWING, BLOCK_STATEMENTS, JavaPunctuator.RWING);
        b.rule(BLOCK_STATEMENTS).is(b.zeroOrMore(BLOCK_STATEMENT));
        b.rule(BLOCK_STATEMENT).is(b.firstOf(LOCAL_VARIABLE_DECLARATION_STATEMENT, b.sequence(b.zeroOrMore(MODIFIER), b.firstOf(CLASS_DECLARATION, ENUM_DECLARATION)), STATEMENT));
        b.rule(LOCAL_VARIABLE_DECLARATION_STATEMENT).is(b.optional(VARIABLE_MODIFIERS), TYPE, VARIABLE_DECLARATORS, JavaPunctuator.SEMI);
        b.rule(VARIABLE_MODIFIERS).is(b.oneOrMore(b.firstOf(ANNOTATION, JavaKeyword.FINAL)));
        b.rule(VARIABLE_DECLARATORS).is(VARIABLE_DECLARATOR, b.zeroOrMore(JavaPunctuator.COMMA, VARIABLE_DECLARATOR));
        b.rule(VARIABLE_DECLARATOR).is(JavaTokenType.IDENTIFIER, b.zeroOrMore(DIM), b.optional(JavaPunctuator.EQU, VARIABLE_INITIALIZER));
        b.rule(STATEMENT).is(b.firstOf(BLOCK, ASSERT_STATEMENT, IF_STATEMENT, FOR_STATEMENT, WHILE_STATEMENT, DO_STATEMENT, TRY_STATEMENT, SWITCH_STATEMENT, SYNCHRONIZED_STATEMENT, RETURN_STATEMENT, THROW_STATEMENT, BREAK_STATEMENT, CONTINUE_STATEMENT, LABELED_STATEMENT, EXPRESSION_STATEMENT, EMPTY_STATEMENT));
        b.rule(EMPTY_STATEMENT).is(JavaPunctuator.SEMI);
        b.rule(LABELED_STATEMENT).is(JavaTokenType.IDENTIFIER, JavaPunctuator.COLON, STATEMENT);
        b.rule(EXPRESSION_STATEMENT).is(STATEMENT_EXPRESSION, JavaPunctuator.SEMI);
        b.rule(IF_STATEMENT).is(JavaKeyword.IF, PAR_EXPRESSION, STATEMENT, b.optional(JavaKeyword.ELSE, STATEMENT));
        b.rule(ASSERT_STATEMENT).is(JavaKeyword.ASSERT, EXPRESSION, b.optional(JavaPunctuator.COLON, EXPRESSION), JavaPunctuator.SEMI);
        b.rule(SWITCH_STATEMENT).is(JavaKeyword.SWITCH, PAR_EXPRESSION, JavaPunctuator.LWING, SWITCH_BLOCK_STATEMENT_GROUPS, JavaPunctuator.RWING);
        b.rule(SWITCH_BLOCK_STATEMENT_GROUPS).is(b.zeroOrMore(SWITCH_BLOCK_STATEMENT_GROUP));
        b.rule(SWITCH_BLOCK_STATEMENT_GROUP).is(SWITCH_LABEL, BLOCK_STATEMENTS);
        b.rule(SWITCH_LABEL).is(b.firstOf(b.sequence(JavaKeyword.CASE, CONSTANT_EXPRESSION, JavaPunctuator.COLON), b.sequence(JavaKeyword.DEFAULT, JavaPunctuator.COLON)));
        b.rule(WHILE_STATEMENT).is(JavaKeyword.WHILE, PAR_EXPRESSION, STATEMENT);
        b.rule(DO_STATEMENT).is(JavaKeyword.DO, STATEMENT, JavaKeyword.WHILE, PAR_EXPRESSION, JavaPunctuator.SEMI);
        b.rule(FOR_STATEMENT).is(b.firstOf(b.sequence(JavaKeyword.FOR, JavaPunctuator.LPAR, b.optional(FOR_INIT), JavaPunctuator.SEMI, b.optional(EXPRESSION), JavaPunctuator.SEMI, b.optional(FOR_UPDATE), JavaPunctuator.RPAR, STATEMENT), b.sequence(JavaKeyword.FOR, JavaPunctuator.LPAR, FORMAL_PARAMETER, JavaPunctuator.COLON, EXPRESSION, JavaPunctuator.RPAR, STATEMENT)));
        b.rule(FOR_INIT).is(b.firstOf(b.sequence(b.zeroOrMore(b.firstOf(JavaKeyword.FINAL, ANNOTATION)), TYPE, VARIABLE_DECLARATORS), b.sequence(STATEMENT_EXPRESSION, b.zeroOrMore(JavaPunctuator.COMMA, STATEMENT_EXPRESSION))));
        b.rule(FOR_UPDATE).is(STATEMENT_EXPRESSION, b.zeroOrMore(JavaPunctuator.COMMA, STATEMENT_EXPRESSION));
        b.rule(BREAK_STATEMENT).is(JavaKeyword.BREAK, b.optional(JavaTokenType.IDENTIFIER), JavaPunctuator.SEMI);
        b.rule(CONTINUE_STATEMENT).is(JavaKeyword.CONTINUE, b.optional(JavaTokenType.IDENTIFIER), JavaPunctuator.SEMI);
        b.rule(RETURN_STATEMENT).is(JavaKeyword.RETURN, b.optional(EXPRESSION), JavaPunctuator.SEMI);
        b.rule(THROW_STATEMENT).is(JavaKeyword.THROW, EXPRESSION, JavaPunctuator.SEMI);
        b.rule(SYNCHRONIZED_STATEMENT).is(JavaKeyword.SYNCHRONIZED, PAR_EXPRESSION, BLOCK);
        b.rule(TRY_STATEMENT).is(b.firstOf(b.sequence(JavaKeyword.TRY, BLOCK, b.firstOf(b.sequence(b.oneOrMore(CATCH_CLAUSE), b.optional(FINALLY_)), FINALLY_)), TRY_WITH_RESOURCES_STATEMENT));
        b.rule(TRY_WITH_RESOURCES_STATEMENT).is(JavaKeyword.TRY, RESOURCE_SPECIFICATION, BLOCK, b.zeroOrMore(CATCH_CLAUSE), b.optional(FINALLY_));
        b.rule(RESOURCE_SPECIFICATION).is(JavaPunctuator.LPAR, RESOURCE, b.zeroOrMore(JavaPunctuator.SEMI, RESOURCE), b.optional(JavaPunctuator.SEMI), JavaPunctuator.RPAR);
        b.rule(RESOURCE).is(b.optional(VARIABLE_MODIFIERS), CLASS_TYPE, VARIABLE_DECLARATOR_ID, JavaPunctuator.EQU, EXPRESSION);
        b.rule(CATCH_CLAUSE).is(JavaKeyword.CATCH, JavaPunctuator.LPAR, CATCH_FORMAL_PARAMETER, JavaPunctuator.RPAR, BLOCK);
        b.rule(CATCH_FORMAL_PARAMETER).is(b.optional(VARIABLE_MODIFIERS), CATCH_TYPE, VARIABLE_DECLARATOR_ID);
        b.rule(CATCH_TYPE).is(QUALIFIED_IDENTIFIER, b.zeroOrMore(JavaPunctuator.OR, QUALIFIED_IDENTIFIER));
        b.rule(FINALLY_).is(JavaKeyword.FINALLY, BLOCK);
    }

    private static void expressions(LexerlessGrammarBuilder b) {
        b.rule(STATEMENT_EXPRESSION).is(EXPRESSION);
        b.rule(CONSTANT_EXPRESSION).is(EXPRESSION);
        b.rule(EXPRESSION).is(ASSIGNMENT_EXPRESSION);
        b.rule(ASSIGNMENT_EXPRESSION).is(CONDITIONAL_EXPRESSION, b.zeroOrMore(ASSIGNMENT_OPERATOR, CONDITIONAL_EXPRESSION)).skipIfOneChild();
        b.rule(ASSIGNMENT_OPERATOR).is(b.firstOf(JavaPunctuator.EQU, JavaPunctuator.PLUSEQU, JavaPunctuator.MINUSEQU, JavaPunctuator.STAREQU, JavaPunctuator.DIVEQU, JavaPunctuator.ANDEQU, JavaPunctuator.OREQU, JavaPunctuator.HATEQU, JavaPunctuator.MODEQU, JavaPunctuator.SLEQU, JavaPunctuator.SREQU, JavaPunctuator.BSREQU));
        b.rule(CONDITIONAL_EXPRESSION).is(CONDITIONAL_OR_EXPRESSION, b.zeroOrMore(JavaPunctuator.QUERY, EXPRESSION, JavaPunctuator.COLON, CONDITIONAL_OR_EXPRESSION)).skipIfOneChild();
        b.rule(CONDITIONAL_OR_EXPRESSION).is(CONDITIONAL_AND_EXPRESSION, b.zeroOrMore(JavaPunctuator.OROR, CONDITIONAL_AND_EXPRESSION)).skipIfOneChild();
        b.rule(CONDITIONAL_AND_EXPRESSION).is(INCLUSIVE_OR_EXPRESSION, b.zeroOrMore(JavaPunctuator.ANDAND, INCLUSIVE_OR_EXPRESSION)).skipIfOneChild();
        b.rule(INCLUSIVE_OR_EXPRESSION).is(EXCLUSIVE_OR_EXPRESSION, b.zeroOrMore(JavaPunctuator.OR, EXCLUSIVE_OR_EXPRESSION)).skipIfOneChild();
        b.rule(EXCLUSIVE_OR_EXPRESSION).is(AND_EXPRESSION, b.zeroOrMore(JavaPunctuator.HAT, AND_EXPRESSION)).skipIfOneChild();
        b.rule(AND_EXPRESSION).is(EQUALITY_EXPRESSION, b.zeroOrMore(JavaPunctuator.AND, EQUALITY_EXPRESSION)).skipIfOneChild();
        b.rule(EQUALITY_EXPRESSION).is(RELATIONAL_EXPRESSION, b.zeroOrMore(b.firstOf(JavaPunctuator.EQUAL, JavaPunctuator.NOTEQUAL), RELATIONAL_EXPRESSION)).skipIfOneChild();
        b.rule(RELATIONAL_EXPRESSION).is(SHIFT_EXPRESSION, b.zeroOrMore(b.firstOf(b.sequence(b.firstOf(JavaPunctuator.GE, JavaPunctuator.GT, JavaPunctuator.LE, JavaPunctuator.LT), SHIFT_EXPRESSION), b.sequence(JavaKeyword.INSTANCEOF, TYPE)))).skipIfOneChild();
        b.rule(SHIFT_EXPRESSION).is(ADDITIVE_EXPRESSION, b.zeroOrMore(b.firstOf(JavaPunctuator.SL, JavaPunctuator.BSR, JavaPunctuator.SR), ADDITIVE_EXPRESSION)).skipIfOneChild();
        b.rule(ADDITIVE_EXPRESSION).is(MULTIPLICATIVE_EXPRESSION, b.zeroOrMore(b.firstOf(JavaPunctuator.PLUS, JavaPunctuator.MINUS), MULTIPLICATIVE_EXPRESSION)).skipIfOneChild();
        b.rule(MULTIPLICATIVE_EXPRESSION).is(UNARY_EXPRESSION, b.zeroOrMore(b.firstOf(JavaPunctuator.STAR, JavaPunctuator.DIV, JavaPunctuator.MOD), UNARY_EXPRESSION)).skipIfOneChild();
        b.rule(UNARY_EXPRESSION_NOT_PLUS_MINUS).is(b.firstOf(CAST_EXPRESSION, METHOD_REFERENCE, b.sequence(PRIMARY, b.zeroOrMore(SELECTOR), b.zeroOrMore(POST_FIX_OP)), b.sequence(JavaPunctuator.TILDA, UNARY_EXPRESSION), b.sequence(JavaPunctuator.BANG, UNARY_EXPRESSION))).skipIfOneChild();
        b.rule(CAST_EXPRESSION).is(JavaPunctuator.LPAR, b.firstOf(b.sequence(BASIC_TYPE, JavaPunctuator.RPAR, UNARY_EXPRESSION), b.sequence(TYPE, b.zeroOrMore(JavaPunctuator.AND, CLASS_TYPE), JavaPunctuator.RPAR, UNARY_EXPRESSION_NOT_PLUS_MINUS)));
        b.rule(UNARY_EXPRESSION).is(b.firstOf(b.sequence(PREFIX_OP, UNARY_EXPRESSION), UNARY_EXPRESSION_NOT_PLUS_MINUS)).skipIfOneChild();
        b.rule(PRIMARY).is(b.firstOf(LAMBDA_EXPRESSION, PAR_EXPRESSION, b.sequence(NON_WILDCARD_TYPE_ARGUMENTS, b.firstOf(EXPLICIT_GENERIC_INVOCATION_SUFFIX, b.sequence(JavaKeyword.THIS, ARGUMENTS))), b.sequence(JavaKeyword.THIS, b.optional(ARGUMENTS)), b.sequence(JavaKeyword.SUPER, SUPER_SUFFIX), LITERAL, b.sequence(JavaKeyword.NEW, b.zeroOrMore(ANNOTATION), CREATOR), b.sequence(QUALIFIED_IDENTIFIER, b.optional(IDENTIFIER_SUFFIX)), b.sequence(BASIC_TYPE, b.zeroOrMore(DIM), JavaPunctuator.DOT, JavaKeyword.CLASS), b.sequence(JavaKeyword.VOID, JavaPunctuator.DOT, JavaKeyword.CLASS)));
        b.rule(METHOD_REFERENCE).is(b.firstOf(JavaKeyword.SUPER, TYPE, PRIMARY), JavaPunctuator.DBLECOLON, b.optional(TYPE_ARGUMENTS), b.firstOf(JavaKeyword.NEW, JavaTokenType.IDENTIFIER));
        b.rule(IDENTIFIER_SUFFIX).is(b.firstOf(b.sequence(JavaPunctuator.LBRK, b.firstOf(b.sequence(JavaPunctuator.RBRK, b.zeroOrMore(DIM), JavaPunctuator.DOT, JavaKeyword.CLASS), b.sequence(EXPRESSION, JavaPunctuator.RBRK))), ARGUMENTS, b.sequence(JavaPunctuator.DOT, b.firstOf(JavaKeyword.CLASS, EXPLICIT_GENERIC_INVOCATION, JavaKeyword.THIS, b.sequence(JavaKeyword.SUPER, ARGUMENTS), b.sequence(JavaKeyword.NEW, b.optional(NON_WILDCARD_TYPE_ARGUMENTS), INNER_CREATOR)))));
        b.rule(EXPLICIT_GENERIC_INVOCATION).is(NON_WILDCARD_TYPE_ARGUMENTS, EXPLICIT_GENERIC_INVOCATION_SUFFIX);
        b.rule(NON_WILDCARD_TYPE_ARGUMENTS).is(JavaPunctuator.LPOINT, TYPE, b.zeroOrMore(JavaPunctuator.COMMA, TYPE), JavaPunctuator.RPOINT);
        b.rule(EXPLICIT_GENERIC_INVOCATION_SUFFIX).is(b.firstOf(b.sequence(JavaKeyword.SUPER, SUPER_SUFFIX), b.sequence(JavaTokenType.IDENTIFIER, ARGUMENTS)));
        b.rule(PREFIX_OP).is(b.firstOf(JavaPunctuator.INC, JavaPunctuator.DEC, JavaPunctuator.PLUS, JavaPunctuator.MINUS));
        b.rule(POST_FIX_OP).is(b.firstOf(JavaPunctuator.INC, JavaPunctuator.DEC));
        b.rule(SELECTOR).is(b.firstOf(b.sequence(JavaPunctuator.DOT, JavaTokenType.IDENTIFIER, b.optional(ARGUMENTS)), b.sequence(JavaPunctuator.DOT, EXPLICIT_GENERIC_INVOCATION), b.sequence(JavaPunctuator.DOT, JavaKeyword.THIS), b.sequence(JavaPunctuator.DOT, JavaKeyword.SUPER, SUPER_SUFFIX), b.sequence(JavaPunctuator.DOT, JavaKeyword.NEW, b.optional(NON_WILDCARD_TYPE_ARGUMENTS), INNER_CREATOR), DIM_EXPR));
        b.rule(SUPER_SUFFIX).is(b.firstOf(ARGUMENTS, b.sequence(JavaPunctuator.DOT, JavaTokenType.IDENTIFIER, b.optional(ARGUMENTS)), b.sequence(JavaPunctuator.DOT, NON_WILDCARD_TYPE_ARGUMENTS, JavaTokenType.IDENTIFIER, ARGUMENTS)));
        b.rule(BASIC_TYPE).is(b.zeroOrMore(ANNOTATION), b.firstOf(JavaKeyword.BYTE, JavaKeyword.SHORT, JavaKeyword.CHAR, JavaKeyword.INT, JavaKeyword.LONG, JavaKeyword.FLOAT, JavaKeyword.DOUBLE, JavaKeyword.BOOLEAN));
        b.rule(ARGUMENTS).is(JavaPunctuator.LPAR, b.optional(EXPRESSION, b.zeroOrMore(JavaPunctuator.COMMA, EXPRESSION)), JavaPunctuator.RPAR);
        b.rule(CREATOR).is(b.firstOf(b.sequence(b.optional(NON_WILDCARD_TYPE_ARGUMENTS), CREATED_NAME, CLASS_CREATOR_REST), b.sequence(b.optional(NON_WILDCARD_TYPE_ARGUMENTS), b.firstOf(CLASS_TYPE, BASIC_TYPE), ARRAY_CREATOR_REST)));
        b.rule(CREATED_NAME).is(b.zeroOrMore(ANNOTATION), JavaTokenType.IDENTIFIER, b.optional(NON_WILDCARD_TYPE_ARGUMENTS), b.zeroOrMore(JavaPunctuator.DOT, b.zeroOrMore(ANNOTATION), JavaTokenType.IDENTIFIER, b.optional(NON_WILDCARD_TYPE_ARGUMENTS)));
        b.rule(INNER_CREATOR).is(JavaTokenType.IDENTIFIER, CLASS_CREATOR_REST);
        b.rule(ARRAY_CREATOR_REST).is(b.zeroOrMore(ANNOTATION), JavaPunctuator.LBRK, b.firstOf(b.sequence(JavaPunctuator.RBRK, b.zeroOrMore(DIM), ARRAY_INITIALIZER), b.sequence(EXPRESSION, JavaPunctuator.RBRK, b.zeroOrMore(DIM_EXPR), b.zeroOrMore(b.zeroOrMore(ANNOTATION), DIM))));
        b.rule(CLASS_CREATOR_REST).is(b.optional(b.firstOf(DIAMOND, TYPE_ARGUMENTS)), ARGUMENTS, b.optional(CLASS_BODY));
        b.rule(DIAMOND).is(JavaPunctuator.LT, JavaPunctuator.GT);
        b.rule(ARRAY_INITIALIZER).is(JavaPunctuator.LWING, b.optional(VARIABLE_INITIALIZER, b.zeroOrMore(JavaPunctuator.COMMA, VARIABLE_INITIALIZER)), b.optional(JavaPunctuator.COMMA), JavaPunctuator.RWING);
        b.rule(VARIABLE_INITIALIZER).is(b.firstOf(ARRAY_INITIALIZER, EXPRESSION));
        b.rule(PAR_EXPRESSION).is(JavaPunctuator.LPAR, EXPRESSION, JavaPunctuator.RPAR);
        b.rule(QUALIFIED_IDENTIFIER).is(b.zeroOrMore(ANNOTATION), JavaTokenType.IDENTIFIER, b.zeroOrMore(JavaPunctuator.DOT, b.zeroOrMore(ANNOTATION), JavaTokenType.IDENTIFIER));
        b.rule(QUALIFIED_IDENTIFIER_LIST).is(QUALIFIED_IDENTIFIER, b.zeroOrMore(JavaPunctuator.COMMA, QUALIFIED_IDENTIFIER));
        b.rule(DIM).is(JavaPunctuator.LBRK, JavaPunctuator.RBRK);
        b.rule(DIM_EXPR).is(b.zeroOrMore(ANNOTATION), JavaPunctuator.LBRK, EXPRESSION, JavaPunctuator.RBRK);
        b.rule(LAMBDA_EXPRESSION).is(LAMBDA_PARAMETERS, ARROW, LAMBDA_BODY);
        b.rule(LAMBDA_PARAMETERS).is(b.firstOf(b.sequence(JavaPunctuator.LPAR, b.optional(JavaTokenType.IDENTIFIER, b.zeroOrMore(JavaPunctuator.COMMA, JavaTokenType.IDENTIFIER)), JavaPunctuator.RPAR), FORMAL_PARAMETERS, JavaTokenType.IDENTIFIER));
        b.rule(LAMBDA_BODY).is(b.firstOf(BLOCK, EXPRESSION));
    }

    private JavaGrammar() {
        String name = this.name();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == '_' && i + 1 < name.length()) {
                sb.append(name.charAt(++i));
                continue;
            }
            sb.append(Character.toLowerCase(name.charAt(i)));
        }
        this.internalName = sb.toString();
    }

    public String toString() {
        return this.internalName;
    }
}

