/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.sonar.api.source.Highlightable;
import org.sonar.java.SonarComponents;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.ast.visitors.JavaAstVisitor;

public class SyntaxHighlighterVisitor
extends JavaAstVisitor
implements AstAndTokenVisitor {
    private final SonarComponents sonarComponents;
    private final Map<AstNodeType, String> types;
    private final Charset charset;
    private Highlightable.HighlightingBuilder highlighting;
    private List<Integer> lineStart;

    public SyntaxHighlighterVisitor(SonarComponents sonarComponents, Charset charset) {
        this.sonarComponents = sonarComponents;
        this.charset = charset;
        ImmutableMap.Builder<Enum, String> typesBuilder = ImmutableMap.builder();
        for (JavaKeyword type : JavaKeyword.values()) {
            typesBuilder.put(type, "k");
        }
        typesBuilder.put(JavaTokenType.CHARACTER_LITERAL, "s");
        typesBuilder.put(JavaTokenType.LITERAL, "s");
        typesBuilder.put(JavaTokenType.FLOAT_LITERAL, "c");
        typesBuilder.put(JavaTokenType.DOUBLE_LITERAL, "c");
        typesBuilder.put(JavaTokenType.LONG_LITERAL, "c");
        typesBuilder.put(JavaTokenType.INTEGER_LITERAL, "c");
        typesBuilder.put(JavaGrammar.ANNOTATION, "a");
        this.types = typesBuilder.build();
    }

    public void init() {
        for (AstNodeType type : this.types.keySet()) {
            this.subscribeTo(new AstNodeType[]{type});
        }
    }

    @Override
    public void visitFile(AstNode astNode) {
        String content;
        if (astNode == null) {
            return;
        }
        this.highlighting = this.sonarComponents.highlightableFor(this.getContext().getFile()).newHighlighting();
        this.lineStart = Lists.newArrayList();
        try {
            content = Files.toString(this.getContext().getFile(), this.charset);
        }
        catch (IOException e) {
            throw Throwables.propagate(e);
        }
        this.lineStart.add(0);
        for (int i = 0; i < content.length(); ++i) {
            if (content.charAt(i) != '\n' && (content.charAt(i) != '\r' || i + 1 >= content.length() || content.charAt(i + 1) == '\n')) continue;
            this.lineStart.add(i + 1);
        }
    }

    @Override
    public void visitNode(AstNode astNode) {
        if (astNode.is(JavaGrammar.ANNOTATION)) {
            this.highlighting.highlight(astNode.getFromIndex(), astNode.getFirstChild(JavaGrammar.QUALIFIED_IDENTIFIER).getToIndex(), this.types.get(astNode.getType()));
        } else {
            this.highlighting.highlight(astNode.getFromIndex(), astNode.getToIndex(), this.types.get(astNode.getType()));
        }
    }

    @Override
    public void visitToken(Token token) {
        for (Trivia trivia : token.getTrivia()) {
            if (!trivia.isComment()) continue;
            Token triviaToken = trivia.getToken();
            int offset = this.getOffset(triviaToken.getLine(), triviaToken.getColumn());
            this.highlighting.highlight(offset, offset + triviaToken.getValue().length(), "cppd");
        }
    }

    private int getOffset(int line, int column) {
        return this.lineStart.get(line - 1) + column;
    }

    @Override
    public void leaveFile(AstNode astNode) {
        if (astNode == null) {
            return;
        }
        this.highlighting.done();
    }
}

