/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.sonar.java.bytecode.BytecodeVisitorNotifier;
import org.sonar.java.bytecode.ClassLoaderBuilder;
import org.sonar.java.bytecode.VirtualMethodsLinker;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmClassProvider;
import org.sonar.java.bytecode.asm.AsmClassProviderImpl;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.loader.SquidClassLoader;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.squid.api.CodeScanner;
import org.sonar.squid.api.CodeVisitor;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.indexer.QueryByType;
import org.sonar.squid.indexer.SquidIndex;

public class BytecodeScanner
extends CodeScanner<BytecodeVisitor> {
    private final SquidIndex indexer;

    public BytecodeScanner(SquidIndex indexer) {
        this.indexer = indexer;
    }

    public BytecodeScanner scan(Collection<File> bytecodeFilesOrDirectories) {
        ClassLoader classLoader = ClassLoaderBuilder.create(bytecodeFilesOrDirectories);
        Collection<SourceCode> classes = this.indexer.search(new QueryByType(SourceClass.class));
        this.scanClasses(classes, new AsmClassProviderImpl(classLoader));
        ((SquidClassLoader)classLoader).close();
        return this;
    }

    public BytecodeScanner scanDirectory(File bytecodeDirectory) {
        return this.scan(Arrays.asList(bytecodeDirectory));
    }

    protected BytecodeScanner scanClasses(Collection<SourceCode> classes, AsmClassProvider classProvider) {
        this.loadByteCodeInformation(classes, classProvider);
        this.linkVirtualMethods(classes, classProvider);
        this.notifyBytecodeVisitors(classes, classProvider);
        return this;
    }

    private void linkVirtualMethods(Collection<SourceCode> classes, AsmClassProvider classProvider) {
        VirtualMethodsLinker linker = new VirtualMethodsLinker();
        for (SourceCode sourceCode : classes) {
            AsmClass asmClass = classProvider.getClass(sourceCode.getKey(), AsmClassProvider.DETAIL_LEVEL.STRUCTURE_AND_CALLS);
            for (AsmMethod method : asmClass.getMethods()) {
                linker.process(method);
            }
        }
    }

    private void notifyBytecodeVisitors(Collection<SourceCode> classes, AsmClassProvider classProvider) {
        BytecodeVisitor[] visitorArray = this.getVisitors().toArray(new BytecodeVisitor[this.getVisitors().size()]);
        for (SourceCode sourceCode : classes) {
            AsmClass asmClass = classProvider.getClass(sourceCode.getKey(), AsmClassProvider.DETAIL_LEVEL.STRUCTURE_AND_CALLS);
            BytecodeVisitorNotifier visitorNotifier = new BytecodeVisitorNotifier(asmClass, visitorArray);
            visitorNotifier.notifyVisitors(this.indexer);
        }
    }

    private void loadByteCodeInformation(Collection<SourceCode> classes, AsmClassProvider classProvider) {
        for (SourceCode sourceCode : classes) {
            classProvider.getClass(sourceCode.getKey(), AsmClassProvider.DETAIL_LEVEL.STRUCTURE_AND_CALLS);
        }
    }

    @Override
    public Collection<Class<? extends BytecodeVisitor>> getVisitorClasses() {
        return Collections.emptyList();
    }

    @Override
    public void accept(CodeVisitor visitor) {
        if (visitor instanceof BytecodeVisitor) {
            super.accept(visitor);
        }
    }
}

