/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.commons.io.IOUtils;
import org.sonar.java.bytecode.loader.Loader;

class JarLoader
implements Loader {
    private final JarFile jarFile;
    private final URL jarUrl;

    public JarLoader(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file can't be null");
        }
        try {
            this.jarFile = new JarFile(file);
            this.jarUrl = new URL("jar", "", -1, file.getAbsolutePath() + "!/");
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to open " + file.getAbsolutePath(), e);
        }
    }

    @Override
    public URL findResource(String name) {
        ZipEntry entry = this.jarFile.getEntry(name);
        if (entry != null) {
            try {
                return new URL(this.jarUrl, name, new JarEntryHandler(entry));
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] loadBytes(String name) {
        InputStream is = null;
        try {
            ZipEntry entry = this.jarFile.getEntry(name);
            if (entry == null) {
                byte[] byArray = null;
                return byArray;
            }
            is = this.jarFile.getInputStream(entry);
            byte[] byArray = IOUtils.toByteArray(is);
            IOUtils.closeQuietly(is);
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    @Override
    public void close() {
        try {
            this.jarFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class JarEntryHandler
    extends URLStreamHandler {
        private ZipEntry entry;

        JarEntryHandler(ZipEntry entry) {
            this.entry = entry;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new URLConnection(u){

                @Override
                public void connect() throws IOException {
                }

                @Override
                public int getContentLength() {
                    return (int)JarEntryHandler.this.entry.getSize();
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    return JarLoader.this.jarFile.getInputStream(JarEntryHandler.this.entry);
                }
            };
        }
    }
}

