/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.visitor;

import org.sonar.graph.DirectedGraph;
import org.sonar.graph.Edge;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmEdge;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceCodeEdge;
import org.sonar.squid.api.SourceCodeEdgeUsage;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourcePackage;

public class DependenciesVisitor
extends BytecodeVisitor {
    private SourceClass fromSourceClass;
    private final DirectedGraph<SourceCode, SourceCodeEdge> graph;

    public DependenciesVisitor(DirectedGraph<SourceCode, SourceCodeEdge> graph) {
        this.graph = graph;
    }

    @Override
    public void visitClass(AsmClass asmClass) {
        this.fromSourceClass = this.getSourceClass(asmClass);
    }

    @Override
    public void visitEdge(AsmEdge edge) {
        AsmClass toAsmClass = edge.getTargetAsmClass();
        SourceClass toSourceClass = this.getSourceClass(toAsmClass);
        switch (edge.getUsage()) {
            case EXTENDS: {
                this.link(this.fromSourceClass, toSourceClass, SourceCodeEdgeUsage.EXTENDS);
                break;
            }
            case IMPLEMENTS: {
                this.link(this.fromSourceClass, toSourceClass, SourceCodeEdgeUsage.IMPLEMENTS);
                break;
            }
            default: {
                this.link(this.fromSourceClass, toSourceClass, SourceCodeEdgeUsage.USES);
            }
        }
    }

    private void link(SourceClass from, SourceClass to, SourceCodeEdgeUsage link) {
        if (this.canWeLinkNodes(from, to) && this.graph.getEdge((Object)from, (Object)to) == null) {
            SourceCodeEdge edge = new SourceCodeEdge(from, to, link);
            this.graph.addEdge((Edge)edge);
            SourceCodeEdge fileEdge = this.createEdgeBetweenParents(SourceFile.class, from, to, edge);
            this.createEdgeBetweenParents(SourcePackage.class, from, to, fileEdge);
        }
    }

    private SourceCodeEdge createEdgeBetweenParents(Class<? extends SourceCode> type, SourceClass from, SourceClass to, SourceCodeEdge rootEdge) {
        SourceCode fromParent = from.getParent(type);
        SourceCode toParent = to.getParent(type);
        SourceCodeEdge parentEdge = null;
        if (this.canWeLinkNodes(fromParent, toParent) && rootEdge != null) {
            if (this.graph.getEdge((Object)fromParent, (Object)toParent) == null) {
                parentEdge = new SourceCodeEdge(fromParent, toParent, SourceCodeEdgeUsage.USES);
                parentEdge.addRootEdge(rootEdge);
                this.graph.addEdge((Edge)parentEdge);
            } else {
                parentEdge = (SourceCodeEdge)this.graph.getEdge((Object)fromParent, (Object)toParent);
                parentEdge.addRootEdge(rootEdge);
            }
        }
        return parentEdge;
    }

    private boolean canWeLinkNodes(SourceCode from, SourceCode to) {
        return from != null && to != null && !from.equals(to);
    }

    public String toString() {
        return "deperecated dependencies metrics";
    }
}

