/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.model.JavaTree;
import org.sonar.java.resolve.Resolve;
import org.sonar.java.resolve.Scope;
import org.sonar.java.resolve.SecondPass;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class FirstPass
extends BaseTreeVisitor {
    private final SemanticModel semanticModel;
    private final List<Symbol> uncompleted = Lists.newArrayList();
    private final SecondPass completer;
    private Resolve.Env env;

    public FirstPass(SemanticModel semanticModel, Resolve resolve) {
        this.semanticModel = semanticModel;
        this.completer = new SecondPass(semanticModel, resolve);
    }

    private void restoreEnvironment(Tree tree) {
        if (this.env.next == null) {
            Preconditions.checkState(tree.is(Tree.Kind.COMPILATION_UNIT));
        } else {
            this.env = this.env.next;
        }
    }

    public void completeSymbols() {
        for (Symbol symbol : this.uncompleted) {
            symbol.complete();
        }
        this.uncompleted.clear();
    }

    public void visitCompilationUnit(CompilationUnitTree tree) {
        Symbol.PackageSymbol symbol = new Symbol.PackageSymbol(null, null);
        symbol.members = new Scope(symbol);
        this.env = new Resolve.Env();
        this.env.packge = symbol;
        this.env.scope = symbol.members;
        this.semanticModel.associateEnv((Tree)tree, this.env);
        super.visitCompilationUnit(tree);
        this.restoreEnvironment((Tree)tree);
        this.completeSymbols();
    }

    public void visitClass(ClassTree tree) {
        int flag = 0;
        boolean anonymousClass = tree.simpleName() == null;
        String name = "";
        if (!anonymousClass) {
            name = tree.simpleName().name();
            flag = this.computeClassFlags(tree);
        }
        Symbol.TypeSymbol symbol = new Symbol.TypeSymbol(flag, name, this.env.scope.owner);
        if (!anonymousClass) {
            this.enterSymbol((Tree)tree, symbol);
        }
        symbol.members = new Scope(symbol);
        symbol.completer = this.completer;
        this.uncompleted.add(symbol);
        this.semanticModel.saveEnv(symbol, this.env);
        Resolve.Env classEnv = this.env.dup();
        classEnv.outer = this.env;
        classEnv.enclosingClass = symbol;
        classEnv.scope = symbol.members;
        this.env = classEnv;
        this.semanticModel.associateEnv((Tree)tree, this.env);
        super.visitClass(tree);
        this.restoreEnvironment((Tree)tree);
    }

    private int computeModifierFlag(AstNode astNode) {
        Preconditions.checkArgument(astNode.is(JavaGrammar.MODIFIER));
        AstNode modifierNode = astNode.getFirstChild();
        int flag = modifierNode.is(JavaKeyword.PRIVATE) ? 2 : (modifierNode.is(JavaKeyword.PROTECTED) ? 4 : (modifierNode.is(JavaKeyword.PUBLIC) ? 1 : 0));
        return flag;
    }

    private int computeFlags(AstNode astNode) {
        int flags = 0;
        for (AstNode modifierNode = astNode.getPreviousAstNode(); modifierNode != null && modifierNode.is(JavaGrammar.MODIFIER); modifierNode = modifierNode.getPreviousAstNode()) {
            flags |= this.computeModifierFlag(modifierNode);
        }
        return flags;
    }

    private int computeClassFlags(ClassTree tree) {
        AstNode astNode = ((JavaTree)tree).getAstNode();
        int flags = this.computeFlags(astNode);
        if (astNode.is(JavaGrammar.INTERFACE_DECLARATION)) {
            flags |= 0x200;
        } else if (astNode.is(JavaGrammar.ENUM_DECLARATION)) {
            flags |= 0x4000;
        } else if (astNode.is(JavaGrammar.ANNOTATION_TYPE_DECLARATION)) {
            flags |= 0x2200;
        }
        if (this.env.scope.owner instanceof Symbol.TypeSymbol && (this.env.enclosingClass.flags() & 0x200) != 0) {
            flags |= 1;
        }
        return flags;
    }

    public void visitMethod(MethodTree tree) {
        this.visitMethodDeclaration(tree);
        super.visitMethod(tree);
        this.restoreEnvironment((Tree)tree);
    }

    private void visitMethodDeclaration(MethodTree tree) {
        String name = tree.returnType() == null ? "<init>" : tree.simpleName().name();
        Symbol.MethodSymbol symbol = new Symbol.MethodSymbol(this.computeMethodFlags(tree), name, this.env.scope.owner);
        this.enterSymbol((Tree)tree, symbol);
        symbol.parameters = new Scope(symbol);
        symbol.completer = this.completer;
        this.uncompleted.add(symbol);
        this.semanticModel.saveEnv(symbol, this.env);
        Resolve.Env methodEnv = this.env.dup();
        methodEnv.scope = symbol.parameters;
        this.env = methodEnv;
    }

    private int computeMethodFlags(MethodTree tree) {
        AstNode astNode = ((JavaTree)tree).getAstNode();
        if (astNode.is(JavaGrammar.METHOD_DECLARATOR_REST, JavaGrammar.VOID_METHOD_DECLARATOR_REST, JavaGrammar.CONSTRUCTOR_DECLARATOR_REST)) {
            return this.computeFlags(astNode.getFirstAncestor((AstNodeType)JavaGrammar.MEMBER_DECL));
        }
        if (astNode.is(JavaGrammar.INTERFACE_METHOD_DECLARATOR_REST, JavaGrammar.VOID_INTERFACE_METHOD_DECLARATORS_REST)) {
            return 1;
        }
        if (astNode.is(JavaGrammar.ANNOTATION_METHOD_REST)) {
            return 1;
        }
        throw new IllegalArgumentException("Unexpected AstNodeType: " + astNode.getType());
    }

    public void visitEnumConstant(EnumConstantTree tree) {
        this.declareVariable(16385, tree.simpleName(), (Tree)tree);
        super.visitEnumConstant(tree);
    }

    public void visitVariable(VariableTree tree) {
        this.declareVariable(this.computeFlags(tree.modifiers()), tree.simpleName(), (Tree)tree);
        super.visitVariable(tree);
    }

    private int computeFlags(ModifiersTree modifiers) {
        return 1;
    }

    private void declareVariable(int flags, IdentifierTree identifierTree, Tree tree) {
        Symbol.VariableSymbol symbol = new Symbol.VariableSymbol(flags, identifierTree.name(), this.env.scope.owner);
        this.enterSymbol(tree, symbol);
        symbol.completer = this.completer;
        this.uncompleted.add(symbol);
        this.semanticModel.saveEnv(symbol, this.env);
    }

    public void visitBlock(BlockTree tree) {
        this.createNewEnvironment((Tree)tree);
        super.visitBlock(tree);
        this.restoreEnvironment((Tree)tree);
    }

    public void visitForStatement(ForStatementTree tree) {
        this.createNewEnvironment((Tree)tree);
        super.visitForStatement(tree);
        this.restoreEnvironment((Tree)tree);
    }

    public void visitForEachStatement(ForEachStatement tree) {
        this.createNewEnvironment((Tree)tree);
        super.visitForEachStatement(tree);
        this.restoreEnvironment((Tree)tree);
    }

    public void visitCatch(CatchTree tree) {
        this.createNewEnvironment((Tree)tree);
        super.visitCatch(tree);
        this.restoreEnvironment((Tree)tree);
    }

    private void createNewEnvironment(Tree tree) {
        Scope scope = new Scope(this.env.scope);
        Resolve.Env newEnv = this.env.dup();
        newEnv.scope = scope;
        this.env = newEnv;
        this.semanticModel.associateEnv(tree, this.env);
    }

    private void enterSymbol(Tree tree, Symbol symbol) {
        this.env.scope.enter(symbol);
        this.semanticModel.associateSymbol(tree, symbol);
    }
}

