/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.resolve.Scope;
import org.sonar.java.resolve.Type;

public class Symbol {
    public static final int PCK = 1;
    public static final int TYP = 2;
    public static final int VAR = 4;
    public static final int MTH = 16;
    public static final int ERRONEOUS = 64;
    public static final int AMBIGUOUS = 65;
    public static final int ABSENT = 66;
    final int kind;
    private final int flags;
    final String name;
    private final Symbol owner;
    Completer completer;
    Type type;

    public Symbol(int kind, int flags, @Nullable String name, @Nullable Symbol owner) {
        this.kind = kind;
        this.flags = flags;
        this.name = name;
        this.owner = owner;
    }

    public int flags() {
        return this.flags;
    }

    public Symbol owner() {
        return this.owner;
    }

    public void complete() {
        if (this.completer != null) {
            Completer c = this.completer;
            this.completer = null;
            c.complete(this);
        }
    }

    public TypeSymbol outermostClass() {
        Symbol symbol = this;
        Symbol result = null;
        while (symbol.kind != 1) {
            result = symbol;
            symbol = symbol.owner();
        }
        return (TypeSymbol)result;
    }

    public PackageSymbol packge() {
        Symbol result = this;
        while (result.kind != 1) {
            result = result.owner();
        }
        return (PackageSymbol)result;
    }

    public TypeSymbol enclosingClass() {
        Symbol result = this;
        while (result != null && result.kind != 2) {
            result = result.owner;
        }
        return (TypeSymbol)result;
    }

    public static class MethodSymbol
    extends Symbol {
        TypeSymbol type;
        Scope parameters;
        List<TypeSymbol> thrown;

        public MethodSymbol(int flags, String name, Type type, Symbol owner) {
            super(16, flags, name, owner);
            ((Symbol)this).type = type;
        }

        public MethodSymbol(int flags, String name, Symbol owner) {
            super(16, flags, name, owner);
        }

        public TypeSymbol getReturnType() {
            return this.type;
        }

        public List<TypeSymbol> getThrownTypes() {
            return this.thrown;
        }
    }

    public static class VariableSymbol
    extends Symbol {
        public VariableSymbol(int flags, String name, Symbol owner) {
            super(4, flags, name, owner);
        }

        public VariableSymbol(int flags, String name, Type type, Symbol owner) {
            super(4, flags, name, owner);
            this.type = type;
        }
    }

    public static class TypeSymbol
    extends Symbol {
        Scope members;

        public TypeSymbol(int flags, String name, Symbol owner) {
            super(2, flags, name, owner);
            this.type = new Type.ClassType(this);
        }

        public Type getSuperclass() {
            this.complete();
            return ((Type.ClassType)this.type).supertype;
        }

        public List<Type> getInterfaces() {
            this.complete();
            return ((Type.ClassType)this.type).interfaces;
        }

        Scope members() {
            this.complete();
            return this.members;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class PackageSymbol
    extends Symbol {
        Scope members;

        public PackageSymbol(@Nullable String name, @Nullable Symbol owner) {
            super(1, 0, name, owner);
        }
    }

    static interface Completer {
        public void complete(Symbol var1);
    }
}

