/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptGrammar;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.squid.api.CodeCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="ArrayAndObjectConstructors", priority=Priority.BLOCKER)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ArrayAndObjectConstructorsCheck
extends SquidCheck<EcmaScriptGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptKeyword.NEW});
    }

    public void visitNode(AstNode astNode) {
        if ("Array".equals(astNode.nextSibling().getTokenValue())) {
            this.getContext().createLineViolation((CodeCheck)this, "Do not use Array constructors.", astNode, new Object[0]);
        }
        if ("Object".equals(astNode.nextSibling().getTokenValue())) {
            this.getContext().createLineViolation((CodeCheck)this, "Do not use Object constructors.", astNode, new Object[0]);
        }
    }
}

