/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Sets;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.HashSet;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptGrammar;
import org.sonar.javascript.checks.EscapeUtils;
import org.sonar.squid.api.CodeCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="DuplicatePropertyName", priority=Priority.CRITICAL)
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class DuplicatePropertyNameCheck
extends SquidCheck<EcmaScriptGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).objectLiteral});
    }

    public void visitNode(AstNode astNode) {
        HashSet values = Sets.newHashSet();
        List propertyAssignments = astNode.findDirectChildren(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).propertyAssignment});
        for (AstNode propertyAssignment : propertyAssignments) {
            String unescaped;
            AstNode propertyName = propertyAssignment.findFirstDirectChild(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).propertyName});
            String value = propertyName.getTokenValue();
            if (value.startsWith("\"") || value.startsWith("'")) {
                value = value.substring(1, value.length() - 1);
            }
            if (values.contains(unescaped = EscapeUtils.unescape(value))) {
                this.getContext().createLineViolation((CodeCheck)this, "Rename or remove duplicate property name '" + value + "'.", propertyName, new Object[0]);
                continue;
            }
            values.add(unescaped);
        }
    }
}

