/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="ElseIfWithoutElse", priority=Priority.MAJOR)
public class ElseIfWithoutElseCheck
extends SquidCheck<EcmaScriptGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).ifStatement});
    }

    public void visitNode(AstNode node) {
        AstNode elseClause;
        if (this.isElseIf(node) && (elseClause = node.findFirstDirectChild(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).elseClause})) == null) {
            this.getContext().createLineViolation((CodeCheck)this, "End this if...else if construct by an else clause.", node, new Object[0]);
        }
    }

    private boolean isElseIf(AstNode node) {
        return this.isElse(node.getParent().getParent());
    }

    private boolean isElse(AstNode node) {
        return node != null && node.is(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).elseClause});
    }
}

