/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.io.Closeables;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.io.Closeable;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.sonar.api.utils.SonarException;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="MissingNewlineAtEndOfFile", priority=Priority.MINOR)
public class MissingNewlineAtEndOfFileCheck
extends SquidCheck<EcmaScriptGrammar> {
    public void visitFile(AstNode astNode) {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(this.getContext().getFile(), "r");
            if (!this.endsWithNewline(randomAccessFile)) {
                this.getContext().createFileViolation((CodeCheck)this, "Add a new line at the end of this file.", new Object[0]);
            }
        }
        catch (IOException e) {
            try {
                throw new SonarException((Throwable)e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(randomAccessFile);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)randomAccessFile);
    }

    private boolean endsWithNewline(RandomAccessFile randomAccessFile) throws IOException {
        if (randomAccessFile.length() < 1L) {
            return false;
        }
        randomAccessFile.seek(randomAccessFile.length() - 1L);
        byte[] chars = new byte[1];
        if (randomAccessFile.read(chars) < 1) {
            return false;
        }
        String ch = new String(chars);
        return "\n".equals(ch) || "\r".equals(ch);
    }
}

