/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="RedeclaredVariable", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class RedeclaredVariableCheck
extends SquidCheck<EcmaScriptGrammar> {
    private Stack<Set<String>> stack;

    public void init() {
        EcmaScriptGrammar g = (EcmaScriptGrammar)this.getContext().getGrammar();
        this.subscribeTo(new AstNodeType[]{g.variableDeclaration, g.variableDeclarationNoIn, g.functionDeclaration, g.functionExpression});
    }

    public void visitFile(AstNode astNode) {
        this.stack = new Stack();
        this.stack.add(new HashSet());
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).functionDeclaration, ((EcmaScriptGrammar)this.getContext().getGrammar()).functionExpression})) {
            HashSet<String> currentScope = new HashSet<String>();
            this.stack.add(currentScope);
            AstNode formalParameterList = astNode.findFirstDirectChild(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).formalParameterList});
            if (formalParameterList != null) {
                for (int i = 0; i < formalParameterList.getNumberOfChildren(); i += 2) {
                    String parameterName = formalParameterList.getChild(i).getTokenValue();
                    currentScope.add(parameterName);
                }
            }
        } else {
            String variableName;
            Set<String> currentScope = this.stack.peek();
            if (currentScope.contains(variableName = astNode.getTokenValue())) {
                this.getContext().createLineViolation((CodeCheck)this, "Rename variable '" + variableName + "' as this name is already used.", astNode, new Object[0]);
            } else {
                currentScope.add(variableName);
            }
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).functionDeclaration, ((EcmaScriptGrammar)this.getContext().getGrammar()).functionExpression})) {
            this.stack.pop();
        }
    }

    public void leaveFile(AstNode astNode) {
        this.stack = null;
    }
}

