/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptGrammar;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.squid.api.CodeCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="SwitchWithoutDefault", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class SwitchWithoutDefaultCheck
extends SquidCheck<EcmaScriptGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).caseBlock});
    }

    public void visitNode(AstNode astNode) {
        AstNode defaultClauseNode = astNode.findFirstDirectChild(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).defaultClause});
        if (defaultClauseNode == null) {
            this.getContext().createLineViolation((CodeCheck)this, "Avoid switch statement without a \"default\" clause.", astNode, new Object[0]);
        } else if (defaultClauseNode.nextSibling().isNot(new AstNodeType[]{EcmaScriptPunctuator.RCURLYBRACE})) {
            this.getContext().createLineViolation((CodeCheck)this, "\"default\" clause should be the last one.", astNode, new Object[0]);
        }
    }
}

