/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="FunctionDeclarationsWithinBlocks", priority=Priority.BLOCKER)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class FunctionDeclarationsWithinBlocksCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.STATEMENT_LIST});
    }

    public void visitNode(AstNode astNode) {
        for (AstNode functionDeclarationNode : astNode.getChildren(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_DECLARATION})) {
            this.getContext().createLineViolation((CodeCheck)this, "Do not use function declarations within blocks.", functionDeclarationNode, new Object[0]);
        }
    }
}

