/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="NestedIfDepth", priority=Priority.MINOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class NestedIfDepthCheck
extends SquidCheck<LexerlessGrammar> {
    private int nestingLevel;
    private static final int DEFAULT_MAXIMUM_NESTING_LEVEL = 3;
    @RuleProperty(key="maximumNestingLevel", defaultValue="3")
    public int maximumNestingLevel = 3;

    public int getMaximumNestingLevel() {
        return this.maximumNestingLevel;
    }

    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.IF_STATEMENT});
    }

    public void visitFile(AstNode astNode) {
        this.nestingLevel = 0;
    }

    public void visitNode(AstNode astNode) {
        if (!this.isElseIf(astNode)) {
            ++this.nestingLevel;
            if (this.nestingLevel == this.getMaximumNestingLevel() + 1) {
                this.getContext().createLineViolation((CodeCheck)this, "This if has a nesting level of {0}, which is higher than the maximum allowed {1}.", astNode, new Object[]{this.nestingLevel, this.getMaximumNestingLevel()});
            }
        }
    }

    public void leaveNode(AstNode astNode) {
        if (!this.isElseIf(astNode)) {
            --this.nestingLevel;
        }
    }

    private boolean isElseIf(AstNode astNode) {
        return astNode.getParent().getPreviousSibling() != null && astNode.getParent().getPreviousSibling().is(new AstNodeType[]{EcmaScriptKeyword.ELSE});
    }
}

