/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="RedeclaredFunction", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class RedeclaredFunctionCheck
extends SquidCheck<LexerlessGrammar> {
    private Stack<Set<String>> stack;

    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_DECLARATION, EcmaScriptGrammar.FUNCTION_EXPRESSION});
    }

    public void visitFile(AstNode astNode) {
        this.stack = new Stack();
        this.stack.add(new HashSet());
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_DECLARATION})) {
            Set<String> currentScope = this.stack.peek();
            String functionName = astNode.getFirstChild(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER}).getTokenValue();
            if (currentScope.contains(functionName)) {
                this.getContext().createLineViolation((CodeCheck)this, "Rename function '" + functionName + "' as this name is already used.", astNode, new Object[0]);
            } else {
                currentScope.add(functionName);
            }
        }
        this.stack.add(new HashSet());
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_DECLARATION, EcmaScriptGrammar.FUNCTION_EXPRESSION})) {
            this.stack.pop();
        }
    }

    public void leaveFile(AstNode astNode) {
        this.stack = null;
    }
}

