/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.AstVisitor;
import com.sonar.sslr.impl.ast.AstWalker;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="VariableShadowing", priority=Priority.MAJOR)
public class VariableShadowingCheck
extends SquidCheck<LexerlessGrammar> {
    private Map<AstNode, Scope> scopes;
    private Scope currentScope;

    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_EXPRESSION, EcmaScriptGrammar.FUNCTION_DECLARATION, EcmaScriptGrammar.FORMAL_PARAMETER_LIST, EcmaScriptGrammar.VARIABLE_DECLARATION, EcmaScriptGrammar.VARIABLE_DECLARATION_NO_IN});
    }

    public void visitFile(AstNode astNode) {
        if (astNode != null) {
            this.scopes = Maps.newHashMap();
            new AstWalker(new AstVisitor[]{new InnerVisitor()}).walkAndVisit(astNode);
            this.currentScope = this.scopes.get(astNode);
        }
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_EXPRESSION, EcmaScriptGrammar.FUNCTION_DECLARATION})) {
            this.currentScope = this.scopes.get(astNode);
        } else if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FORMAL_PARAMETER_LIST})) {
            for (AstNode identifierNode : astNode.getChildren(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER})) {
                this.check(identifierNode);
            }
        } else if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.VARIABLE_DECLARATION, EcmaScriptGrammar.VARIABLE_DECLARATION_NO_IN})) {
            this.check(astNode.getFirstChild(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER}));
        }
    }

    private void check(AstNode astNode) {
        Preconditions.checkState((boolean)astNode.is(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER}));
        String identifier = astNode.getTokenValue();
        Scope scope = this.currentScope.outerScope;
        while (scope != null) {
            if (scope.declaration.containsKey(identifier)) {
                this.getContext().createLineViolation((CodeCheck)this, "'" + identifier + "' hides variable declared in outer scope.", astNode, new Object[0]);
                break;
            }
            scope = scope.outerScope;
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_EXPRESSION, EcmaScriptGrammar.FUNCTION_DECLARATION})) {
            this.currentScope = this.currentScope.outerScope;
        }
    }

    public void leaveFile(AstNode astNode) {
        this.currentScope = null;
        this.scopes = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InnerVisitor
    implements AstVisitor {
        private Scope currentScope;

        private InnerVisitor() {
        }

        public List<AstNodeType> getAstNodeTypesToVisit() {
            return Arrays.asList(EcmaScriptGrammar.FUNCTION_EXPRESSION, EcmaScriptGrammar.FUNCTION_DECLARATION, EcmaScriptGrammar.VARIABLE_DECLARATION, EcmaScriptGrammar.VARIABLE_DECLARATION_NO_IN, EcmaScriptGrammar.FORMAL_PARAMETER_LIST);
        }

        public void visitFile(AstNode astNode) {
            this.currentScope = new Scope();
            VariableShadowingCheck.this.scopes.put(astNode, this.currentScope);
        }

        public void visitNode(AstNode astNode) {
            if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_EXPRESSION, EcmaScriptGrammar.FUNCTION_DECLARATION})) {
                this.currentScope = new Scope(this.currentScope);
                VariableShadowingCheck.this.scopes.put(astNode, this.currentScope);
            } else if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FORMAL_PARAMETER_LIST})) {
                for (AstNode identifierNode : astNode.getChildren(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER})) {
                    this.currentScope.declare(identifierNode);
                }
            } else if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.VARIABLE_DECLARATION, EcmaScriptGrammar.VARIABLE_DECLARATION_NO_IN})) {
                this.currentScope.declare(astNode.getFirstChild(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER}));
            }
        }

        public void leaveNode(AstNode astNode) {
            if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_EXPRESSION, EcmaScriptGrammar.FUNCTION_DECLARATION})) {
                this.currentScope = this.currentScope.outerScope;
            }
        }

        public void leaveFile(AstNode astNode) {
        }
    }

    private static class Scope {
        private final Scope outerScope;
        private Map<String, AstNode> declaration = Maps.newHashMap();

        public Scope() {
            this.outerScope = null;
        }

        public Scope(Scope outerScope) {
            this.outerScope = outerScope;
        }

        private void declare(AstNode astNode) {
            Preconditions.checkState((boolean)astNode.is(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER}));
            String identifier = astNode.getTokenValue();
            if (!this.declaration.containsKey(identifier)) {
                this.declaration.put(identifier, astNode);
            }
        }
    }
}

