/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1442", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class AlertUseCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.CALL_EXPRESSION});
    }

    public void visitNode(AstNode astNode) {
        AstNode simpleCallExpr = astNode.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.SIMPLE_CALL_EXPRESSION});
        if (simpleCallExpr != null && AlertUseCheck.isAlertCall(simpleCallExpr.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.MEMBER_EXPRESSION}))) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove this usage of alert(...).", astNode, new Object[0]);
        }
    }

    public static boolean isAlertCall(AstNode memberExpr) {
        return memberExpr != null && memberExpr.getNumberOfChildren() == 1 && memberExpr.getFirstChild().is(new AstNodeType[]{EcmaScriptGrammar.PRIMARY_EXPRESSION}) && "alert".equals(memberExpr.getFirstChild().getTokenValue());
    }
}

