/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1472", priority=Priority.CRITICAL)
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class FunctionCallArgumentsOnNewLineCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.CALL_EXPRESSION});
    }

    public void visitNode(AstNode astNode) {
        for (AstNode args : this.getCallArguments(astNode)) {
            int memberCallingLine = args.getPreviousSibling().getLastToken().getLine();
            if (args.getTokenLine() == memberCallingLine) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Make those call arguments start on line {0}", args, new Object[]{memberCallingLine});
        }
    }

    private List<AstNode> getCallArguments(AstNode callExpr) {
        ArrayList callArguments = Lists.newArrayList();
        AstNode simpleCallExpr = callExpr.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.SIMPLE_CALL_EXPRESSION});
        if (simpleCallExpr != null) {
            callArguments.add(simpleCallExpr.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.ARGUMENTS}));
        }
        callArguments.addAll(callExpr.getChildren(new AstNodeType[]{EcmaScriptGrammar.ARGUMENTS}));
        return callArguments;
    }
}

