/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="SwitchWithoutDefault", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class SwitchWithoutDefaultCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.CASE_BLOCK});
    }

    public void visitNode(AstNode astNode) {
        AstNode defaultClauseNode = astNode.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.DEFAULT_CLAUSE});
        if (defaultClauseNode == null) {
            this.getContext().createLineViolation((CodeCheck)this, "Avoid switch statement without a \"default\" clause.", astNode, new Object[0]);
        } else if (defaultClauseNode.getNextSibling().isNot(new AstNodeType[]{EcmaScriptPunctuator.RCURLYBRACE})) {
            this.getContext().createLineViolation((CodeCheck)this, "\"default\" clause should be the last one.", astNode, new Object[0]);
        }
    }
}

