/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.io.Files;
import com.sonar.sslr.api.AstNode;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.api.utils.SonarException;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.CharsetAwareVisitor;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="TrailingWhitespace", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class TrailingWhitespaceCheck
extends SquidCheck<LexerlessGrammar>
implements CharsetAwareVisitor {
    private Charset charset;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void visitFile(AstNode astNode) {
        List lines;
        try {
            lines = Files.readLines((File)this.getContext().getFile(), (Charset)this.charset);
        }
        catch (IOException e) {
            throw new SonarException((Throwable)e);
        }
        for (int i = 0; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            if (line.length() <= 0 || !Pattern.matches("[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]", line.subSequence(line.length() - 1, line.length()))) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Remove the useless trailing whitespaces at the end of this line.", i + 1, new Object[0]);
        }
    }
}

