/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="FunctionDeclarationsWithinBlocks", priority=Priority.BLOCKER)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class FunctionDeclarationsWithinBlocksCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.BLOCK});
    }

    public void visitNode(AstNode astNode) {
        AstNode stmtList = astNode.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.STATEMENT_LIST});
        if (stmtList != null) {
            for (AstNode declarationNode : stmtList.getChildren(new AstNodeType[]{EcmaScriptGrammar.DECLARATION})) {
                if (!declarationNode.getFirstChild().is(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_DECLARATION})) continue;
                this.getContext().createLineViolation((CodeCheck)this, "Do not use function declarations within blocks.", declarationNode, new Object[0]);
            }
        }
    }
}

