/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import org.apache.commons.lang.StringUtils;
import org.sonar.squidbridge.checks.SquidCheck;

public class CommentContainsPatternChecker {
    private final SquidCheck<?> check;
    private final String pattern;
    private final String message;

    public CommentContainsPatternChecker(SquidCheck<?> check, String pattern, String message) {
        this.check = check;
        this.pattern = pattern;
        this.message = message;
    }

    public void visitToken(Token token) {
        for (Trivia trivia : token.getTrivia()) {
            String comment = trivia.getToken().getOriginalValue();
            if (!StringUtils.containsIgnoreCase((String)comment, (String)this.pattern)) continue;
            String[] lines = comment.split("\r\n?|\n");
            for (int i = 0; i < lines.length; ++i) {
                if (!StringUtils.containsIgnoreCase((String)lines[i], (String)this.pattern) || this.isLetterAround(lines[i], this.pattern)) continue;
                this.check.getContext().createLineViolation(this.check, this.message, trivia.getToken().getLine() + i, new Object[0]);
            }
        }
    }

    private boolean isLetterAround(String line, String pattern) {
        int start = StringUtils.indexOfIgnoreCase((String)line, (String)pattern);
        int end = start + pattern.length();
        boolean pre = start > 0 ? Character.isLetter(line.charAt(start - 1)) : false;
        boolean post = end < line.length() - 1 ? Character.isLetter(line.charAt(end)) : false;
        return pre || post;
    }
}

