/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1145", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class IfConditionalAlwaysTrueOrFalseCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.IF_STATEMENT});
    }

    public void visitNode(AstNode astNode) {
        if (IfConditionalAlwaysTrueOrFalseCheck.isOnlyBooleanLiteral(astNode.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.CONDITION}))) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove this \"if\" statement.", astNode, new Object[0]);
        }
    }

    public static boolean isOnlyBooleanLiteral(AstNode exprNode) {
        AstNode exprChild = exprNode.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.EXPRESSION}).getFirstChild();
        if (!exprChild.getToken().equals(exprChild.getLastToken())) {
            return false;
        }
        String tokenValue = exprChild.getTokenValue();
        return EcmaScriptKeyword.TRUE.getValue().equals(tokenValue) || EcmaScriptKeyword.FALSE.getValue().equals(tokenValue);
    }
}

