/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="NestedIfDepth", priority=Priority.MINOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class NestedControlFlowDepthCheck
extends SquidCheck<LexerlessGrammar> {
    private int nestedLevel;
    private static final int DEFAULT_MAXIMUM_NESTING_LEVEL = 3;
    @RuleProperty(key="maximumNestingLevel", defaultValue="3")
    public int maximumNestingLevel = 3;

    public int getMaximumNestingLevel() {
        return this.maximumNestingLevel;
    }

    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.IF_STATEMENT, EcmaScriptGrammar.FOR_STATEMENT, EcmaScriptGrammar.FOR_IN_STATEMENT, EcmaScriptGrammar.WHILE_STATEMENT, EcmaScriptGrammar.DO_WHILE_STATEMENT, EcmaScriptGrammar.SWITCH_STATEMENT, EcmaScriptGrammar.TRY_STATEMENT});
    }

    public void visitFile(AstNode astNode) {
        this.nestedLevel = 0;
    }

    public void visitNode(AstNode astNode) {
        if (!this.isElseIf(astNode)) {
            ++this.nestedLevel;
            if (this.nestedLevel == this.getMaximumNestingLevel() + 1) {
                this.getContext().createLineViolation((CodeCheck)this, "Refactor this code to not nest more than {0} if/for/while/switch/try statements.", astNode, new Object[]{this.getMaximumNestingLevel()});
            }
        }
    }

    public void leaveNode(AstNode astNode) {
        if (!this.isElseIf(astNode)) {
            --this.nestedLevel;
        }
    }

    private boolean isElseIf(AstNode astNode) {
        return astNode.getParent().getPreviousSibling() != null && astNode.getParent().getPreviousSibling().is(new AstNodeType[]{EcmaScriptKeyword.ELSE});
    }
}

