/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="Parentheses", priority=Priority.MINOR)
public class ParenthesesCheck
extends SquidCheck<LexerlessGrammar> {
    private static final Set<String> NO_PARENTHESES_AFTER = ImmutableSet.of((Object)"delete", (Object)"typeof", (Object)"void", (Object)"return", (Object)"throw", (Object)"new", (Object[])new String[]{"in"});

    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.UNARY_EXPRESSION, EcmaScriptGrammar.EXPRESSION, EcmaScriptGrammar.NEW_EXPRESSION});
    }

    public void visitNode(AstNode node) {
        if ("(".equals(node.getTokenValue()) && node.getPreviousSibling() != null && NO_PARENTHESES_AFTER.contains(node.getPreviousSibling().getTokenValue())) {
            this.getContext().createLineViolation((CodeCheck)this, "Those parentheses are useless.", node, new Object[0]);
        }
    }
}

