/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S138", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class TooManyLinesInFunctionCheck
extends SquidCheck<LexerlessGrammar> {
    private static final int DEFAULT = 100;
    @RuleProperty(key="max", defaultValue="100")
    public int max = 100;

    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.METHOD, EcmaScriptGrammar.GENERATOR_METHOD, EcmaScriptGrammar.GENERATOR_DECLARATION, EcmaScriptGrammar.GENERATOR_EXPRESSION, EcmaScriptGrammar.FUNCTION_DECLARATION, EcmaScriptGrammar.FUNCTION_EXPRESSION});
    }

    public void visitNode(AstNode astNode) {
        int nbLines = TooManyLinesInFunctionCheck.getNumberOfLine(astNode);
        if (nbLines > this.max && !this.isImmediatelyInvokedFunctionExpression(astNode)) {
            this.getContext().createLineViolation((CodeCheck)this, "This function has {0} lines, which is greater than the {1} lines authorized. Split it into smaller functions.", astNode, new Object[]{nbLines, this.max});
        }
    }

    private boolean isImmediatelyInvokedFunctionExpression(AstNode functionDec) {
        AstNode rcurly = functionDec.getFirstChild(new AstNodeType[]{EcmaScriptPunctuator.RCURLYBRACE});
        AstNode nextAstNode = rcurly.getNextAstNode();
        return functionDec.is(new AstNodeType[]{EcmaScriptGrammar.GENERATOR_EXPRESSION, EcmaScriptGrammar.FUNCTION_EXPRESSION}) && (nextAstNode.is(new AstNodeType[]{EcmaScriptGrammar.ARGUMENTS}) || nextAstNode.is(new AstNodeType[]{EcmaScriptPunctuator.RPARENTHESIS}) && nextAstNode.getNextAstNode().is(new AstNodeType[]{EcmaScriptGrammar.ARGUMENTS}));
    }

    public static int getNumberOfLine(AstNode functionNode) {
        int firstLine = functionNode.getFirstChild(new AstNodeType[]{EcmaScriptPunctuator.LCURLYBRACE}).getTokenLine();
        int lastLine = functionNode.getFirstChild(new AstNodeType[]{EcmaScriptPunctuator.RCURLYBRACE}).getTokenLine();
        return lastLine - firstLine + 1;
    }
}

