/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="CurlyBraces", priority=Priority.MAJOR, tags={"convention", "cwe", "misra"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class AlwaysUseCurlyBracesCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.IF_STATEMENT, Tree.Kind.FOR_IN_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.DO_WHILE_STATEMENT, Tree.Kind.ELSE_CLAUSE});
    }

    public void visitNode(AstNode astNode) {
        if (!this.isElseIf(astNode) && !astNode.hasDirectChildren(new AstNodeType[]{Tree.Kind.BLOCK})) {
            this.getContext().createLineViolation((CodeCheck)this, "Missing curly brace.", astNode, new Object[0]);
        }
    }

    private boolean isElseIf(AstNode statement) {
        return statement.is(new AstNodeType[]{Tree.Kind.ELSE_CLAUSE}) && statement.hasDirectChildren(new AstNodeType[]{Tree.Kind.IF_STATEMENT});
    }
}

