/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import javax.annotation.Nullable;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.declaration.InitializedBindingElementTree;
import org.sonar.javascript.model.interfaces.expression.ArrowFunctionTree;
import org.sonar.javascript.model.interfaces.expression.AssignmentExpressionTree;
import org.sonar.javascript.model.interfaces.expression.BinaryExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ParenthesisedExpressionTree;
import org.sonar.javascript.model.interfaces.statement.DoWhileStatementTree;
import org.sonar.javascript.model.interfaces.statement.ExpressionStatementTree;
import org.sonar.javascript.model.interfaces.statement.ForStatementTree;
import org.sonar.javascript.model.interfaces.statement.WhileStatementTree;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="AssignmentWithinCondition", priority=Priority.MAJOR, tags={"bug", "cwe", "misra"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class AssignmentWithinConditionCheck
extends BaseTreeVisitor {
    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.scan((Tree)tree.statement());
    }

    public void visitWhileStatement(WhileStatementTree tree) {
        this.scan((Tree)tree.statement());
    }

    public void visitInitializedBindingElement(InitializedBindingElementTree tree) {
        this.scan((Tree)tree.left());
        this.visitInitialisationExpression(tree.right());
    }

    private void visitInitialisationExpression(ExpressionTree left) {
        if (left instanceof AssignmentExpressionTree) {
            this.scan((Tree)((AssignmentExpressionTree)left).variable());
            this.visitInitialisationExpression(((AssignmentExpressionTree)left).expression());
        } else {
            this.scan((Tree)left);
        }
    }

    public void visitForStatement(ForStatementTree tree) {
        this.visitCommaOperatorExpression(tree.init());
        this.scan((Tree)tree.condition());
        this.scan((Tree)tree.statement());
    }

    public void visitArrowFunction(ArrowFunctionTree lambdaExpressionTree) {
        if (!(lambdaExpressionTree.conciseBody() instanceof AssignmentExpressionTree)) {
            super.visitArrowFunction(lambdaExpressionTree);
        }
    }

    public void visitExpressionStatement(ExpressionStatementTree tree) {
        Tree expressionTree = tree.expression();
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.COMMA_OPERATOR})) {
            this.visitCommaOperatorExpression((Tree)((BinaryExpressionTree)expressionTree).leftOperand());
            this.visitCommaOperatorExpression((Tree)((BinaryExpressionTree)expressionTree).rightOperand());
        } else {
            while (expressionTree instanceof AssignmentExpressionTree) {
                AssignmentExpressionTree assignmentExpressionTree = (AssignmentExpressionTree)expressionTree;
                this.scan((Tree)assignmentExpressionTree.variable());
                expressionTree = assignmentExpressionTree.expression();
            }
            this.scan(expressionTree);
        }
    }

    public void visitCommaOperatorExpression(Tree expression) {
        if (expression == null) {
            return;
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.COMMA_OPERATOR})) {
            this.visitCommaOperatorExpression((Tree)((BinaryExpressionTree)expression).leftOperand());
            this.visitCommaOperatorExpression((Tree)((BinaryExpressionTree)expression).rightOperand());
        } else if (expression instanceof AssignmentExpressionTree) {
            super.visitAssignmentExpression((AssignmentExpressionTree)expression);
        } else {
            this.scan(expression);
        }
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (AssignmentWithinConditionCheck.isRelationalExpression((Tree)tree)) {
            this.visitInnerExpression(tree.leftOperand());
            this.visitInnerExpression(tree.rightOperand());
        } else {
            super.visitBinaryExpression(tree);
        }
    }

    private void visitInnerExpression(ExpressionTree tree) {
        AssignmentExpressionTree assignmentExpressionTree = AssignmentWithinConditionCheck.getInnerAssignmentExpression(tree);
        if (assignmentExpressionTree != null) {
            super.visitAssignmentExpression(assignmentExpressionTree);
        } else {
            this.scan((Tree)tree);
        }
    }

    @Nullable
    private static AssignmentExpressionTree getInnerAssignmentExpression(ExpressionTree tree) {
        ParenthesisedExpressionTree parenthesizedTree;
        if (tree.is(new Tree.Kind[]{Tree.Kind.PARENTHESISED_EXPRESSION}) && (parenthesizedTree = (ParenthesisedExpressionTree)tree).expression() instanceof AssignmentExpressionTree) {
            return (AssignmentExpressionTree)parenthesizedTree.expression();
        }
        return null;
    }

    private static boolean isRelationalExpression(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO}) || tree.is(new Tree.Kind[]{Tree.Kind.STRICT_EQUAL_TO}) || tree.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO}) || tree.is(new Tree.Kind[]{Tree.Kind.STRICT_NOT_EQUAL_TO}) || tree.is(new Tree.Kind[]{Tree.Kind.LESS_THAN}) || tree.is(new Tree.Kind[]{Tree.Kind.LESS_THAN_OR_EQUAL_TO}) || tree.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN}) || tree.is(new Tree.Kind[]{Tree.Kind.GREATER_THAN_OR_EQUAL_TO}) || tree.is(new Tree.Kind[]{Tree.Kind.RELATIONAL_IN});
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        super.visitAssignmentExpression(tree);
        this.getContext().addIssue((CodeVisitor)this, (Tree)tree, "Extract the assignment out of this expression.");
    }
}

