/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Sets;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.HashSet;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.EscapeUtils;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="DuplicatePropertyName", priority=Priority.CRITICAL, tags={"bug", "pitfall"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class DuplicatePropertyNameCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.OBJECT_LITERAL});
    }

    public void visitNode(AstNode astNode) {
        HashSet values = Sets.newHashSet();
        List pairProperties = astNode.getChildren(new AstNodeType[]{Tree.Kind.PAIR_PROPERTY, Tree.Kind.IDENTIFIER_REFERENCE});
        for (AstNode property : pairProperties) {
            String unescaped;
            AstNode propertyName = property.getFirstChild();
            String value = propertyName.getTokenValue();
            if (value.startsWith("\"") || value.startsWith("'")) {
                value = value.substring(1, value.length() - 1);
            }
            if (values.contains(unescaped = EscapeUtils.unescape(value))) {
                this.getContext().createLineViolation((CodeCheck)this, "Rename or remove duplicate property name '" + value + "'.", propertyName, new Object[0]);
                continue;
            }
            values.add(unescaped);
        }
    }
}

