/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.statement.BlockTree;
import org.sonar.javascript.model.interfaces.statement.ForInStatementTree;
import org.sonar.javascript.model.interfaces.statement.StatementTree;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="ForIn", priority=Priority.MAJOR, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ForInCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.FOR_IN_STATEMENT});
    }

    public void visitNode(AstNode astNode) {
        ForInStatementTree forInStatement = (ForInStatementTree)astNode;
        StatementTree statementNode = forInStatement.statement();
        if (statementNode.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            BlockTree block = (BlockTree)statementNode;
            StatementTree statementTree = statementNode = !block.statements().isEmpty() ? (StatementTree)block.statements().get(0) : null;
        }
        if (statementNode != null && !statementNode.is(new Tree.Kind[]{Tree.Kind.IF_STATEMENT})) {
            this.getContext().createLineViolation((CodeCheck)this, "Insert an if statement at the beginning of this loop to filter items.", astNode, new Object[0]);
        }
    }
}

