/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.api.EcmaScriptMetric;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.api.SourceFunction;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.squidbridge.measures.MetricDef;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="FunctionComplexity", priority=Priority.MAJOR, tags={"brain-overload"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class FunctionComplexityCheck
extends SquidCheck<LexerlessGrammar> {
    private static final int DEFAULT_MAXIMUM_FUNCTION_COMPLEXITY_THRESHOLD = 10;
    @RuleProperty(key="maximumFunctionComplexityThreshold", defaultValue="10")
    private int maximumFunctionComplexityThreshold = 10;

    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.METHOD, Tree.Kind.GENERATOR_METHOD, Tree.Kind.GENERATOR_DECLARATION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.FUNCTION_EXPRESSION});
    }

    public void leaveNode(AstNode node) {
        SourceFunction function = (SourceFunction)this.getContext().peekSourceCode();
        if (function.getInt((MetricDef)EcmaScriptMetric.COMPLEXITY) > this.maximumFunctionComplexityThreshold) {
            this.getContext().createLineViolation((CodeCheck)this, "Function has a complexity of {0,number,integer} which is greater than {1,number,integer} authorized.", node, new Object[]{function.getInt((MetricDef)EcmaScriptMetric.COMPLEXITY), this.maximumFunctionComplexityThreshold});
        }
    }

    public void setMaximumFunctionComplexityThreshold(int threshold) {
        this.maximumFunctionComplexityThreshold = threshold;
    }
}

