/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.statement.BlockTree;
import org.sonar.javascript.model.interfaces.statement.StatementTree;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="FunctionDeclarationsWithinBlocks", priority=Priority.BLOCKER, tags={"cross-browser", "user-experience"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class FunctionDeclarationsWithinBlocksCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.BLOCK});
    }

    public void visitNode(AstNode astNode) {
        if (CheckUtils.isFunction(astNode.getParent())) {
            return;
        }
        BlockTree block = (BlockTree)astNode;
        for (StatementTree stmt : block.statements()) {
            if (!stmt.is(new Tree.Kind[]{Tree.Kind.FUNCTION_DECLARATION})) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Do not use function declarations within blocks.", (AstNode)stmt, new Object[0]);
        }
    }
}

