/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.io.Files;
import com.sonar.sslr.api.AstNode;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.sonar.api.utils.SonarException;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.CharsetAwareVisitor;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="TabCharacter", priority=Priority.MINOR, tags={"convention"})
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class TabCharacterCheck
extends SquidCheck<LexerlessGrammar>
implements CharsetAwareVisitor {
    private Charset charset;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void visitFile(AstNode astNode) {
        List lines;
        try {
            lines = Files.readLines((File)this.getContext().getFile(), (Charset)this.charset);
        }
        catch (IOException e) {
            throw new SonarException((Throwable)e);
        }
        for (int i = 0; i < lines.size(); ++i) {
            if (!((String)lines.get(i)).contains("\t")) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Replace all tab characters in this file by sequences of white-spaces.", i + 1, new Object[0]);
            break;
        }
    }
}

