/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.statement.ExpressionStatementTree;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="UnreachableCode", priority=Priority.MAJOR, tags={"misra", "unused"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class UnreachableCodeCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.BREAK_STATEMENT, Tree.Kind.RETURN_STATEMENT, Tree.Kind.CONTINUE_STATEMENT, Tree.Kind.THROW_STATEMENT});
    }

    public void visitNode(AstNode node) {
        AstNode nextStatement = node.getNextSibling();
        if (UnreachableCodeCheck.isUnReachableCode(nextStatement)) {
            this.getContext().createLineViolation((CodeCheck)this, "This statement can't be reached and so start a dead code block.", nextStatement, new Object[0]);
        }
    }

    public static boolean isUnReachableCode(AstNode node) {
        return node != null && !node.is(new AstNodeType[]{Tree.Kind.ELSE_CLAUSE, Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.GENERATOR_DECLARATION, Tree.Kind.CLASS_DECLARATION, EcmaScriptPunctuator.RCURLYBRACE}) && (!node.is(new AstNodeType[]{Tree.Kind.EXPRESSION_STATEMENT}) || !((ExpressionStatementTree)node).expression().is(new Tree.Kind[]{Tree.Kind.CLASS_EXPRESSION}));
    }
}

