/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.javascript.model.implementations.declaration.ParameterListTreeImpl;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="UnusedFunctionArgument", priority=Priority.MAJOR, tags={"misra", "unused"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class UnusedFunctionArgumentCheck
extends SquidCheck<LexerlessGrammar> {
    private static final GrammarRuleKey[] FUNCTION_NODES = new GrammarRuleKey[]{Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_DECLARATION};
    private Scope currentScope;

    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.FORMAL_PARAMETER_LIST, Tree.Kind.IDENTIFIER_REFERENCE});
        this.subscribeTo((AstNodeType[])FUNCTION_NODES);
    }

    public void visitFile(AstNode astNode) {
        this.currentScope = null;
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is((AstNodeType[])FUNCTION_NODES) || astNode.is(new AstNodeType[]{Tree.Kind.METHOD, Tree.Kind.GENERATOR_METHOD})) {
            this.currentScope = new Scope(this.currentScope, astNode);
        } else if (this.currentScope != null && astNode.is(new AstNodeType[]{Tree.Kind.FORMAL_PARAMETER_LIST}) && astNode.getParent().isNot(new AstNodeType[]{Tree.Kind.METHOD, Tree.Kind.GENERATOR_METHOD})) {
            this.declareInCurrentScope(((ParameterListTreeImpl)astNode).parameterIdentifiers());
        } else if (this.currentScope != null && astNode.is(new AstNodeType[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
            if ("arguments".equals(astNode.getTokenValue())) {
                this.currentScope.useArgumentsArray = true;
            }
            this.currentScope.use(astNode);
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is((AstNodeType[])FUNCTION_NODES)) {
            if (!this.currentScope.useArgumentsArray) {
                this.reportUnusedArguments(astNode);
            }
            this.currentScope = this.currentScope.outerScope;
        } else if (astNode.is(new AstNodeType[]{Tree.Kind.METHOD, Tree.Kind.GENERATOR_METHOD})) {
            this.currentScope = this.currentScope.outerScope;
        }
    }

    public void leaveFile(AstNode astNode) {
        this.currentScope = null;
    }

    public void reportUnusedArguments(AstNode functionNode) {
        if (functionNode.is(new AstNodeType[]{Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.GENERATOR_DECLARATION})) {
            this.reportAllUnusedArgs();
        } else {
            this.reportDanglingUnusedArgs();
        }
    }

    public void reportAllUnusedArgs() {
        int nbUnusedArgs = 0;
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : this.currentScope.arguments.entrySet()) {
            if ((Integer)entry.getValue() != 0) continue;
            builder.append((String)entry.getKey() + " ");
            ++nbUnusedArgs;
        }
        this.createIssue(builder, false, nbUnusedArgs);
    }

    public void reportDanglingUnusedArgs() {
        int nbUnusedArgs = 0;
        boolean hasMetUsedArg = false;
        StringBuilder builder = new StringBuilder();
        ArrayList entries = Lists.newArrayList(this.currentScope.arguments.entrySet());
        for (Map.Entry entry : Lists.reverse((List)entries)) {
            int usages = (Integer)entry.getValue();
            if (usages == 0 && !hasMetUsedArg) {
                builder.append((String)entry.getKey() + " ");
                ++nbUnusedArgs;
                continue;
            }
            if (usages <= 0 || hasMetUsedArg) continue;
            hasMetUsedArg = true;
        }
        this.createIssue(builder, true, nbUnusedArgs);
    }

    public void createIssue(StringBuilder builder, boolean reverse, int nbArgs) {
        if (nbArgs > 1) {
            String argsList;
            if (reverse) {
                Object[] args = builder.deleteCharAt(builder.length() - 1).toString().split(" ");
                ArrayUtils.reverse((Object[])args);
                argsList = StringUtils.join((Object[])args, (String)", ");
            } else {
                argsList = StringUtils.join((Object[])builder.toString().split(" "), (String)", ");
            }
            this.getContext().createLineViolation((CodeCheck)this, "Remove the unused function parameters \"" + argsList + "\".", this.currentScope.functionDec, new Object[0]);
        } else if (nbArgs == 1) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove the unused function parameter \"" + builder.toString().trim() + "\".", this.currentScope.functionDec, new Object[0]);
        }
    }

    private void declareInCurrentScope(List<IdentifierTree> identifiers) {
        for (IdentifierTree identifier : identifiers) {
            this.currentScope.declare(identifier);
        }
    }

    private static class Scope {
        private final Scope outerScope;
        private final AstNode functionDec;
        private final Map<String, Integer> arguments;
        private boolean useArgumentsArray = false;

        public Scope(Scope outerScope, AstNode functionDec) {
            this.outerScope = outerScope;
            this.functionDec = functionDec;
            this.arguments = Maps.newLinkedHashMap();
        }

        private void declare(IdentifierTree identifierTree) {
            String identifier = identifierTree.name();
            this.arguments.put(identifier, 0);
        }

        private void use(AstNode astNode) {
            Preconditions.checkState((boolean)astNode.is(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER, Tree.Kind.BINDING_IDENTIFIER, Tree.Kind.IDENTIFIER_REFERENCE}));
            String identifier = astNode.getTokenValue();
            Scope scope = this;
            while (scope != null) {
                Integer usage = scope.arguments.get(identifier);
                if (usage != null) {
                    Integer n = usage;
                    Integer n2 = usage = Integer.valueOf(usage + 1);
                    scope.arguments.put(identifier, usage);
                    return;
                }
                scope = scope.outerScope;
            }
        }
    }
}

