/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.AstVisitor;
import com.sonar.sslr.impl.ast.AstWalker;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.model.implementations.declaration.ParameterListTreeImpl;
import org.sonar.javascript.model.implementations.statement.VariableDeclarationTreeImpl;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="VariableShadowing", priority=Priority.MAJOR, tags={"pitfall"})
public class VariableShadowingCheck
extends SquidCheck<LexerlessGrammar> {
    private Map<AstNode, Scope> scopes;
    private static final AstNodeType[] CONST_AND_VAR_NODES = new AstNodeType[]{Tree.Kind.VAR_DECLARATION, Tree.Kind.LET_DECLARATION, Tree.Kind.CONST_DECLARATION};
    private Scope currentScope;

    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.FORMAL_PARAMETER_LIST});
        this.subscribeTo(CheckUtils.functionNodesArray());
        this.subscribeTo(CONST_AND_VAR_NODES);
    }

    public void visitFile(AstNode astNode) {
        if (astNode != null) {
            this.scopes = Maps.newHashMap();
            new AstWalker(new AstVisitor[]{new InnerVisitor()}).walkAndVisit(astNode);
            this.currentScope = this.scopes.get(astNode);
        }
    }

    public void visitNode(AstNode astNode) {
        if (CheckUtils.isFunction(astNode)) {
            this.currentScope = this.scopes.get(astNode);
        } else if (astNode.is(new AstNodeType[]{Tree.Kind.FORMAL_PARAMETER_LIST})) {
            this.checkIdentifiers(((ParameterListTreeImpl)astNode).parameterIdentifiers());
        } else if (astNode.is(CONST_AND_VAR_NODES)) {
            this.checkIdentifiers(((VariableDeclarationTreeImpl)astNode).variableIdentifiers());
        }
    }

    private void check(IdentifierTree identifierTree) {
        String identifier = identifierTree.name();
        Scope scope = this.currentScope.outerScope;
        while (scope != null) {
            if (scope.declaration.containsKey(identifier)) {
                this.getContext().createLineViolation((CodeCheck)this, "\"" + identifier + "\" hides variable declared in outer scope.", (AstNode)identifierTree, new Object[0]);
                break;
            }
            scope = scope.outerScope;
        }
    }

    public void leaveNode(AstNode astNode) {
        if (CheckUtils.isFunction(astNode)) {
            this.currentScope = this.currentScope.outerScope;
        }
    }

    public void leaveFile(AstNode astNode) {
        this.currentScope = null;
        this.scopes = null;
    }

    private void checkIdentifiers(List<IdentifierTree> identifiers) {
        for (IdentifierTree identifier : identifiers) {
            this.check(identifier);
        }
    }

    private class InnerVisitor
    implements AstVisitor {
        private Scope currentScope;

        private InnerVisitor() {
        }

        public List<AstNodeType> getAstNodeTypesToVisit() {
            return ImmutableList.builder().add((Object)Tree.Kind.FORMAL_PARAMETER_LIST).addAll(Arrays.asList(CONST_AND_VAR_NODES)).addAll(CheckUtils.FUNCTION_NODES).build();
        }

        public void visitFile(AstNode astNode) {
            this.currentScope = new Scope();
            VariableShadowingCheck.this.scopes.put(astNode, this.currentScope);
        }

        public void visitNode(AstNode astNode) {
            if (CheckUtils.isFunction(astNode)) {
                this.currentScope = new Scope(this.currentScope);
                VariableShadowingCheck.this.scopes.put(astNode, this.currentScope);
            } else if (astNode.is(new AstNodeType[]{Tree.Kind.FORMAL_PARAMETER_LIST})) {
                this.declareInCurrentScope(((ParameterListTreeImpl)astNode).parameterIdentifiers());
            } else if (astNode.is(CONST_AND_VAR_NODES)) {
                this.declareInCurrentScope(((VariableDeclarationTreeImpl)astNode).variableIdentifiers());
            }
        }

        private void declareInCurrentScope(List<IdentifierTree> identifiers) {
            for (IdentifierTree identifier : identifiers) {
                this.currentScope.declare(identifier);
            }
        }

        public void leaveNode(AstNode astNode) {
            if (CheckUtils.isFunction(astNode)) {
                this.currentScope = this.currentScope.outerScope;
            }
        }

        public void leaveFile(AstNode astNode) {
        }
    }

    private static class Scope {
        private final Scope outerScope;
        private final Map<String, IdentifierTree> declaration = Maps.newHashMap();

        public Scope() {
            this.outerScope = null;
        }

        public Scope(Scope outerScope) {
            this.outerScope = outerScope;
        }

        private void declare(IdentifierTree identifierTree) {
            String identifier = identifierTree.name();
            if (!this.declaration.containsKey(identifier)) {
                this.declaration.put(identifier, identifierTree);
            }
        }
    }
}

