/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.SubscriptionBaseVisitor;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.BinaryExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2688", name="\"NaN\" should not be used in comparisons", priority=Priority.BLOCKER, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class ComparisonWithNaNCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.EQUAL_TO, (Object)Tree.Kind.NOT_EQUAL_TO, (Object)Tree.Kind.STRICT_EQUAL_TO, (Object)Tree.Kind.STRICT_NOT_EQUAL_TO);
    }

    public void visitNode(Tree tree) {
        BinaryExpressionTree equalityExpr = (BinaryExpressionTree)tree;
        if (this.isNaN(equalityExpr.leftOperand()) || this.isNaN(equalityExpr.rightOperand())) {
            this.addIssue(tree, "Use a test of the format \"a " + equalityExpr.operator().text() + " a\" instead.");
        }
    }

    private boolean isNaN(ExpressionTree expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE}) && "NaN".equals(((IdentifierTree)expression).name());
    }
}

