/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="ExcessiveParameterList", name="[Functions|Methods|Lambdas] should not have too many parameters", priority=Priority.MAJOR, tags={"brain-overload"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNIT_TESTABILITY")
@SqaleConstantRemediation(value="20min")
public class ExcessiveParameterListCheck
extends SquidCheck<LexerlessGrammar> {
    private static final int DEFAULT_MAXIMUM_FUNCTION_PARAMETERS = 7;
    @RuleProperty(key="maximumFunctionParameters", description="The maximum authorized number of parameters", defaultValue="7")
    private int maximumFunctionParameters = 7;

    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.FORMAL_PARAMETER_LIST});
    }

    public void visitNode(AstNode node) {
        int numberOfParameters = this.getNumberOfParameters(node);
        if (numberOfParameters > this.maximumFunctionParameters) {
            this.getContext().createLineViolation((CodeCheck)this, "Function has {0,number,integer} parameters which is greater than {1,number,integer} authorized.", node.getFirstChild(new AstNodeType[]{Tree.Kind.BINDING_IDENTIFIER, Tree.Kind.INITIALIZED_BINDING_ELEMENT, EcmaScriptGrammar.BINDING_REST_ELEMENT}), new Object[]{numberOfParameters, this.maximumFunctionParameters});
        }
    }

    private int getNumberOfParameters(AstNode node) {
        return (node.getNumberOfChildren() - 3) / 2 + 1;
    }

    public void setMaximumFunctionParameters(int threshold) {
        this.maximumFunctionParameters = threshold;
    }
}

