/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="FutureReservedWords", name="\"future reserved words\" should not be used as identifiers", priority=Priority.CRITICAL, tags={"lock-in", "pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LANGUAGE_RELATED_PORTABILITY")
@SqaleConstantRemediation(value="5min")
public class FutureReservedWordsCheck
extends SquidCheck<LexerlessGrammar> {
    private static final Set<String> FUTURE_RESERVED_WORDS = ImmutableSet.of((Object)"implements", (Object)"interface", (Object)"package", (Object)"private", (Object)"protected", (Object)"public", (Object[])new String[]{"static"});

    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER});
    }

    public void visitNode(AstNode astNode) {
        String value = astNode.getTokenValue();
        if (FUTURE_RESERVED_WORDS.contains(value)) {
            this.getContext().createLineViolation((CodeCheck)this, "Rename \"" + value + "\" identifier to prevent potential conflicts with future evolutions of the JavaScript language.", astNode, new Object[0]);
        }
    }
}

