/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="HtmlComments", name="HTML-style comments should not be used", priority=Priority.MAJOR, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LANGUAGE_RELATED_PORTABILITY")
@SqaleConstantRemediation(value="5min")
public class HtmlCommentsCheck
extends SquidCheck<LexerlessGrammar>
implements AstAndTokenVisitor {
    public void visitToken(Token token) {
        for (Trivia trivia : token.getTrivia()) {
            if (!trivia.isComment() || !trivia.getToken().getValue().startsWith("<!--")) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Replace this HTML-style comment by a standard comment", trivia.getToken().getLine(), new Object[0]);
        }
    }
}

