/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="LineLength", name="Lines should not be too long", priority=Priority.MINOR, tags={"convention"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class LineLengthCheck
extends SquidCheck<LexerlessGrammar>
implements AstAndTokenVisitor {
    private Token previousToken;
    private static final int DEFAULT_MAXIMUM_LINE_LENHGTH = 80;
    @RuleProperty(key="maximumLineLength", description="The maximum authorized line length.", defaultValue="80")
    public int maximumLineLength = 80;

    public int getMaximumLineLength() {
        return this.maximumLineLength;
    }

    public void visitFile(AstNode astNode) {
        this.previousToken = null;
    }

    public void leaveFile(AstNode astNode) {
        this.previousToken = null;
    }

    public void visitToken(Token token) {
        if (!token.isGeneratedCode()) {
            int length;
            if (this.previousToken != null && this.previousToken.getLine() != token.getLine() && (length = this.previousToken.getColumn() + this.previousToken.getValue().length()) > this.getMaximumLineLength()) {
                this.getContext().createLineViolation((CodeCheck)this, "The line contains {0,number,integer} characters which is greater than {1,number,integer} authorized.", this.previousToken.getLine(), new Object[]{length, this.getMaximumLineLength()});
            }
            this.previousToken = token;
        }
    }
}

